/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.AllQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanQuery
implements SearchQuery {
    private static final String KEY = "boolean";
    private final Set<SearchQuery> andQueries;
    private final Set<SearchQuery> orQueries;
    private final Set<SearchQuery> notQueries;

    @Override
    public String getKey() {
        return KEY;
    }

    public static SearchQuery composeAndQuery(Set<? extends SearchQuery> subqueries) {
        if (subqueries.isEmpty()) {
            return new AllQuery();
        }
        if (subqueries.size() == 1) {
            return subqueries.iterator().next();
        }
        return new BooleanQuery(subqueries, null, null);
    }

    public static SearchQuery composeAndQuery(SearchQuery searchQueryOne, SearchQuery searchQueryTwo) {
        return BooleanQuery.composeAndQuery(new HashSet<SearchQuery>(Arrays.asList(searchQueryOne, searchQueryTwo)));
    }

    public static SearchQuery composeOrQuery(Set<? extends SearchQuery> subqueries) {
        if (subqueries.isEmpty()) {
            return new AllQuery();
        }
        if (subqueries.size() == 1) {
            return subqueries.iterator().next();
        }
        return new BooleanQuery(null, subqueries, null);
    }

    public static SearchQuery composeOrQuery(SearchQuery searchQueryOne, SearchQuery searchQueryTwo) {
        return BooleanQuery.composeOrQuery(new HashSet<SearchQuery>(Arrays.asList(searchQueryOne, searchQueryTwo)));
    }

    public BooleanQuery(Set<? extends SearchQuery> must, Set<? extends SearchQuery> should, Set<? extends SearchQuery> mustNot) {
        if ((must == null || must.isEmpty()) && (should == null || should.isEmpty())) {
            throw new IllegalArgumentException("At least one must or should query parameter needs to be supplied.");
        }
        this.andQueries = must == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<SearchQuery>(must));
        this.orQueries = should == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<SearchQuery>(should));
        this.notQueries = mustNot == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<SearchQuery>(mustNot));
    }

    public Set<SearchQuery> getMustQueries() {
        return this.andQueries;
    }

    public Set<SearchQuery> getShouldQueries() {
        return this.orQueries;
    }

    public Set<SearchQuery> getMustNotQueries() {
        return this.notQueries;
    }

    @Override
    public List getParameters() {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>(this.andQueries.size() + this.orQueries.size() + this.notQueries.size());
        queries.addAll(this.andQueries);
        queries.addAll(this.orQueries);
        queries.addAll(this.notQueries);
        return queries;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BooleanQuery other = (BooleanQuery)obj;
        return new EqualsBuilder().append(this.andQueries, other.andQueries).append(this.orQueries, other.orQueries).append(this.notQueries, other.notQueries).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(127, 37).append(this.andQueries).append(this.orQueries).append(this.notQueries).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("andQueries", this.andQueries).append("orQueries", this.orQueries).append("notQueries", this.notQueries).toString();
    }
}

