/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTypeQuery
implements SearchQuery {
    private static final String KEY = "contentType";
    private final Set<ContentTypeEnum> contentTypes;

    public ContentTypeQuery(ContentTypeEnum contentType) {
        this(Collections.singletonList(contentType));
    }

    public ContentTypeQuery(Collection<ContentTypeEnum> contentTypes) {
        if (contentTypes == null) {
            throw new IllegalArgumentException("contentTypes should not be null");
        }
        if (contentTypes.isEmpty()) {
            throw new IllegalArgumentException("contentTypes should not be an empty list");
        }
        if (contentTypes.contains(null)) {
            throw new IllegalArgumentException("contentTypes should not contain a null value");
        }
        this.contentTypes = new HashSet<ContentTypeEnum>(contentTypes);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> types = new ArrayList<String>(this.contentTypes.size());
        for (ContentTypeEnum ct : this.contentTypes) {
            types.add(ct.getRepresentation());
        }
        return types;
    }

    public Set<ContentTypeEnum> getContentTypes() {
        return this.contentTypes;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContentTypeQuery)) {
            return false;
        }
        ContentTypeQuery other = (ContentTypeQuery)obj;
        return ((Object)this.contentTypes).equals(other.contentTypes);
    }

    public int hashCode() {
        return ((Object)this.contentTypes).hashCode() + KEY.hashCode();
    }
}

