/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.search.v2.query;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.search.v2.SearchQuery;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class LabelQuery
implements SearchQuery {
    private static final String KEY = "label";
    private final ParsedLabelName label;

    public LabelQuery(String label) {
        this.label = LabelParser.parse(label);
        this.makeGlobalIfNecessary();
    }

    public LabelQuery(Label label) {
        this.label = LabelParser.create(label);
        this.makeGlobalIfNecessary();
    }

    public String getKey() {
        return KEY;
    }

    public List getParameters() {
        return Collections.singletonList(this.label);
    }

    public String getLabelAsString() {
        return LabelParser.render(this.label);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LabelQuery other = (LabelQuery)obj;
        return new EqualsBuilder().append((Object)this.label, (Object)other.label).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(117, 37).append((Object)this.label).toHashCode();
    }

    private void makeGlobalIfNecessary() {
        if (this.label == null) {
            return;
        }
        if (StringUtils.isBlank((String)this.label.getOwner()) && StringUtils.isBlank((String)this.label.getPrefix())) {
            this.label.setPrefix(Namespace.GLOBAL.getPrefix());
        }
    }
}

