/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.PermissionsFixer;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.persistence.dao.SpacePermissionDao;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.List;

public abstract class AbstractSpacePermissionManager
implements SpacePermissionManager {
    protected SpacePermissionDao spacePermissionDao;
    private UserAccessor userAccessor;

    public void setSpacePermissionDao(SpacePermissionDao spacePermissionDao) {
        this.spacePermissionDao = spacePermissionDao;
    }

    public void fixPermissions() {
        try {
            new PermissionsFixer(this, this.getUserAccessor()).fixPermissions();
        }
        catch (Exception e) {
            throw new InfrastructureException("Unable to fix permissions: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasPermissionForSpace(User user, List permissionTypes, Space space) {
        return GeneralUtil.isSuperUser(user) || this.hasPermission(permissionTypes, space, user);
    }

    protected UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

