/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class ContentPermission
extends ConfluenceEntityObject
implements Comparable {
    private static final Category log = Category.getInstance(ContentPermission.class);
    public static final String VIEW_PERMISSION = "View";
    public static final String EDIT_PERMISSION = "Edit";
    private String type;
    private String userName;
    private String groupName;
    private ContentPermissionSet owningSet;
    private UserAccessor userAccessor;

    public ContentPermission() {
    }

    public static ContentPermission createUserPermission(String type, String userName) {
        if (StringUtils.isEmpty((String)type)) {
            throw new IllegalArgumentException("Type is required.");
        }
        if (StringUtils.isEmpty((String)userName)) {
            throw new IllegalArgumentException("Username is required.");
        }
        return new ContentPermission(type, null, userName);
    }

    public static ContentPermission createGroupPermission(String type, String groupName) {
        if (StringUtils.isEmpty((String)type)) {
            throw new IllegalArgumentException("Type is required.");
        }
        if (StringUtils.isEmpty((String)groupName)) {
            throw new IllegalArgumentException("Groupname is required.");
        }
        return new ContentPermission(type, groupName, null);
    }

    protected ContentPermission(String type, String groupName, String userName) {
        this.type = type;
        this.groupName = groupName;
        this.userName = userName;
    }

    public boolean isPermitted(User user) {
        if (user == null) {
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        if (this.isUserPermission()) {
            return this.userName.equalsIgnoreCase(user.getName());
        }
        Group group = this.getUserAccessor().getGroup(this.groupName);
        return this.getUserAccessor().hasMembership(group, user);
    }

    private boolean isValid() {
        if (StringUtils.isEmpty((String)this.type)) {
            log.error((Object)"Corrupt content permission found with null type.");
            return false;
        }
        if (StringUtils.isEmpty((String)this.userName) && StringUtils.isEmpty((String)this.groupName)) {
            log.error((Object)"Corrupt content permission found with null username and groupname.");
            return false;
        }
        return true;
    }

    public boolean isGroupPermission() {
        return this.getGroupName() != null;
    }

    public boolean isUserPermission() {
        return this.getUserName() != null;
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        this.type = type;
    }

    public String getUserName() {
        return this.userName;
    }

    private void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    private UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroup() {
        return this.getGroupName();
    }

    private void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public ContentPermissionSet getOwningSet() {
        return this.owningSet;
    }

    public void setOwningSet(ContentPermissionSet owningSet) {
        this.owningSet = owningSet;
    }

    public int compareTo(Object o) {
        ContentPermission that = (ContentPermission)o;
        if (!this.getType().equals(that.getType())) {
            return EDIT_PERMISSION.equals(this.getType()) ? -1 : 1;
        }
        if (this.isGroupPermission()) {
            if (that.isGroupPermission()) {
                return this.getGroupName().compareTo(that.getGroupName());
            }
            return -1;
        }
        if (that.isGroupPermission()) {
            return 1;
        }
        return this.getUserName().compareTo(that.getUserName());
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "[type=" + this.type + ", userName=" + this.userName + ", groupName=" + this.groupName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContentPermission that = (ContentPermission)o;
        if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
        return result;
    }
}

