/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ContentPermissionSet
extends EntityObject {
    private Set contentPermissions = new TreeSet();
    private ContentEntityObject owningContent;
    private String type;

    public ContentPermissionSet() {
    }

    public ContentPermissionSet(String type, ContentEntityObject owningContent) {
        this.type = type;
        this.owningContent = owningContent;
    }

    public void addContentPermission(ContentPermission contentPermission) {
        if (this.contentPermissions.add(contentPermission)) {
            contentPermission.setOwningSet(this);
        }
    }

    public void removeContentPermission(ContentPermission contentPermission) {
        if (this.contentPermissions.remove(contentPermission)) {
            contentPermission.setOwningSet(null);
        }
    }

    public boolean isPermitted(User user) {
        for (ContentPermission contentPermission : this.contentPermissions) {
            if (!contentPermission.isPermitted(user)) continue;
            return true;
        }
        return false;
    }

    private void setContentPermissions(Set contentPermissions) {
        this.contentPermissions = contentPermissions;
    }

    private Set getContentPermissions() {
        return this.contentPermissions;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEmpty() {
        return this.contentPermissions.isEmpty();
    }

    public int size() {
        return this.contentPermissions.size();
    }

    public boolean contains(ContentPermission contentPermission) {
        return this.contentPermissions.contains(contentPermission);
    }

    public ContentEntityObject getOwningContent() {
        return this.owningContent;
    }

    public void setOwningContent(ContentEntityObject owningContent) {
        this.owningContent = owningContent;
    }

    public Iterator iterator() {
        return Collections.unmodifiableCollection(this.contentPermissions).iterator();
    }

    public List getGroupNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ContentPermission contentPermission : this.contentPermissions) {
            if (!contentPermission.isGroupPermission()) continue;
            result.add(contentPermission.getGroupName());
        }
        return result;
    }

    public List getUserNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ContentPermission contentPermission : this.contentPermissions) {
            if (!contentPermission.isUserPermission()) continue;
            result.add(contentPermission.getUserName());
        }
        return result;
    }

    public Collection getAllExcept(Collection exclusions) {
        TreeSet copy = new TreeSet(this.contentPermissions);
        copy.removeAll(new TreeSet(exclusions));
        return copy;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + this.hashCode() + "[type=" + this.type + ", owningContent=" + this.owningContent + ", contentPermissions=" + this.contentPermissions + "]";
    }
}

