/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.DeactivatedUserChecker;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.Hibernate;

public class DefaultPermissionManager
implements PermissionManager {
    private Map delegates;
    private DeactivatedUserChecker deactivatedUserChecker;
    private SpacePermissionManager spacePermissionManager;

    public boolean hasPermission(User user, Permission permission, Object target) {
        if (target == null || this.cantUseConfluence(user)) {
            return false;
        }
        return permission.checkAgainst(this.findDelegateFor(target), user, target);
    }

    public boolean hasCreatePermission(User user, Object container, Class typeToCreate) {
        if (container == null || this.cantUseConfluence(user)) {
            return false;
        }
        return this.findDelegateFor(typeToCreate).canCreate(user, container);
    }

    private boolean cantUseConfluence(User user) {
        return this.deactivatedUserChecker.isDeactivated(user) || !this.spacePermissionManager.hasPermission("USECONFLUENCE", null, user);
    }

    public List getPermittedEntities(User user, Permission permission, List objects) {
        ArrayList returnList = new ArrayList(objects.size());
        for (Object o : objects) {
            if (!this.hasPermission(user, permission, o)) continue;
            returnList.add(o);
        }
        return returnList;
    }

    public List getPermittedEntities(User user, Permission permission, Iterator objects, int maxResults) {
        ArrayList returnList = new ArrayList(Math.min(100, maxResults));
        while (objects.hasNext() && returnList.size() < maxResults) {
            Object o = objects.next();
            if (!this.hasPermission(user, permission, o)) continue;
            returnList.add(o);
        }
        return returnList;
    }

    public List getPermittedEntities(User user, Permission permission, Iterator entities, int maxResults, Collection otherCriteria) {
        ArrayList permittedEntities = new ArrayList();
        while (permittedEntities.size() <= maxResults && entities.hasNext()) {
            Object originalEntity = entities.next();
            if (!this.hasPermission(user, permission, originalEntity) || !this.checkCriteria(otherCriteria, permittedEntities, originalEntity)) continue;
            permittedEntities.add(originalEntity);
        }
        return permittedEntities;
    }

    public boolean isGlobalAdministrator(User user) {
        return this.hasPermission(user, Permission.ADMINISTER, TARGET_APPLICATION);
    }

    public boolean isConfluenceAdministrator(User user) {
        return this.hasPermission(user, Permission.ADMINISTER, TARGET_APPLICATION);
    }

    private boolean checkCriteria(Collection criteria, List alreadyChosenEntities, Object entity) {
        if (criteria.size() == 0) {
            return true;
        }
        for (PermissionManager.Criterion c : criteria) {
            if (c.test(alreadyChosenEntities, entity)) continue;
            return false;
        }
        return true;
    }

    private PermissionDelegate findDelegateFor(Object target) {
        PermissionDelegate delegate = (PermissionDelegate)this.delegates.get(this.makeDelegatesKeyFor(target));
        if (delegate == null) {
            throw new IllegalArgumentException("Could not check permissions for " + target + " no suitable delegate found.");
        }
        return delegate;
    }

    private Object makeDelegatesKeyFor(Object target) {
        if (target instanceof String) {
            return target;
        }
        if (target instanceof Class) {
            return this.getClassNameOnly((Class)target);
        }
        return this.getClassNameOnly(Hibernate.getClass((Object)target));
    }

    private Object getClassNameOnly(Class klass) {
        if (User.class.isAssignableFrom(klass)) {
            return "User";
        }
        if (Group.class.isAssignableFrom(klass)) {
            return "Group";
        }
        String name = klass.getName();
        int i = name.lastIndexOf(".");
        return i == -1 ? name : name.substring(i + 1);
    }

    public void setDelegates(Map delegates) {
        this.delegates = delegates;
    }

    public void setDeactivatedUserChecker(DeactivatedUserChecker deactivatedUserChecker) {
        this.deactivatedUserChecker = deactivatedUserChecker;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }
}

