/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.EntityRuntimeException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SetSpacePermissionChecker;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;

public class DefaultSetSpacePermissionChecker
implements SetSpacePermissionChecker {
    private PermissionManager permissionManager;
    private BootstrapManager bootstrapManager;
    private UserManager userManager;
    private GroupManager groupManager;

    public boolean canSetPermission(User user, SpacePermission spacePermission) {
        if (!this.bootstrapManager.isSetupComplete()) {
            return true;
        }
        if (GeneralUtil.isSuperUser(user)) {
            return true;
        }
        if ("SYSTEMADMINISTRATOR".equalsIgnoreCase(spacePermission.getType())) {
            return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
        }
        if (spacePermission.isSpacePermission()) {
            return this.permissionManager.hasPermission(user, Permission.SET_PERMISSIONS, spacePermission.getSpace());
        }
        if (spacePermission.isGlobalPermission()) {
            if (spacePermission.isUserPermission()) {
                User spacePermissionUser;
                try {
                    spacePermissionUser = this.userManager.getUser(spacePermission.getUserName());
                }
                catch (EntityException e) {
                    throw new EntityRuntimeException("Error occurred trying to fetch the user in " + spacePermission, e);
                }
                if (spacePermissionUser == null) {
                    throw new EntityRuntimeException("User declared in " + spacePermission + " does not exist.");
                }
                return this.permissionManager.hasPermission(user, Permission.SET_PERMISSIONS, spacePermissionUser);
            }
            if (spacePermission.isGroupPermission()) {
                Group spacePermissionGroup;
                try {
                    spacePermissionGroup = this.groupManager.getGroup(spacePermission.getGroup());
                }
                catch (EntityException e) {
                    throw new EntityRuntimeException("Error occurred trying to fetch the group in " + spacePermission, e);
                }
                if (spacePermissionGroup == null) {
                    throw new EntityRuntimeException("Group declared in " + spacePermission + " does not exist.");
                }
                return this.permissionManager.hasPermission(user, Permission.SET_PERMISSIONS, spacePermissionGroup);
            }
        }
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }
}

