/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.AbstractSpacePermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.util.profiling.UtilTimerStack;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DefaultSpacePermissionManager
extends AbstractSpacePermissionManager {
    private static Logger log = Logger.getLogger(DefaultSpacePermissionManager.class);

    public void flushCaches() {
    }

    public void savePermission(SpacePermission permission) {
        if (permission.isInvalidAnonymousPermission()) {
            throw new IllegalArgumentException("You are not allowed to add the " + permission.getType() + " permission to the anonymous user.");
        }
        this.savePermissionToDao(permission);
    }

    public void removePermission(SpacePermission permission) {
        SpacePermission realPermission = this.spacePermissionDao.getById(permission.getId());
        if (realPermission == null) {
            log.error((Object)("Could not retrieve a space permission from Hibernate with the id '" + permission.getId() + "'"));
            return;
        }
        this.removePermissionFromDao(realPermission);
        if (realPermission.getSpace() != null) {
            realPermission.getSpace().removePermission(realPermission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(String permissionType, Space space, User remoteUser) {
        String permissionCheck = this.getPermissionCheckAsString(permissionType, space, remoteUser);
        if (GeneralUtil.isSuperUser(remoteUser)) {
            log.debug((Object)(permissionCheck + " User is super-user. PERMISSION GRANTED."));
            return true;
        }
        UtilTimerStack.push((String)("DefaultSpacePermissionManager.hasPermission" + permissionCheck));
        try {
            if (this.getUserAccessor().isDeactivated(remoteUser)) {
                log.debug((Object)(permissionCheck + " User is disabled. PERMISSION DENIED."));
                boolean bl = false;
                return bl;
            }
            log.debug((Object)(permissionCheck + " User is enabled, checking application permissions"));
            if (remoteUser != null && !this.hasPermissionViaGroups(remoteUser, null, "USECONFLUENCE") && !this.hasPermissionAsUser(remoteUser, null, "USECONFLUENCE")) {
                log.debug((Object)(permissionCheck + " User can't use application. PERMISSION DENIED."));
                boolean bl = false;
                return bl;
            }
            log.debug((Object)(permissionCheck + " User is permitted to use application (or anonymous), checking anonymous permissions"));
            if (this.hasPermissionAsAnonymousUser(space, permissionType)) {
                log.debug((Object)(permissionCheck + " Anonymous permissions allow access. PERMISSION GRANTED."));
                boolean bl = true;
                return bl;
            }
            if (remoteUser == null) {
                log.debug((Object)(permissionCheck + " Anonymous access not permitted. PERMISSION DENIED."));
                boolean bl = false;
                return bl;
            }
            log.debug((Object)(permissionCheck + " Anonymous permissions don't allow access, checking user and group permissions"));
            if (this.hasPermissionViaGroups(remoteUser, space, permissionType)) {
                log.debug((Object)(permissionCheck + " User is a member of a group with access to space. PERMISSION GRANTED."));
                boolean bl = true;
                return bl;
            }
            if (this.hasPermissionAsUser(remoteUser, space, permissionType)) {
                log.debug((Object)(permissionCheck + " User has access to space. PERMISSION GRANTED."));
                boolean bl = true;
                return bl;
            }
            log.debug((Object)(permissionCheck + " No remaining checks. PERMISSION DENIED."));
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)("Error checking permission " + permissionCheck + ". Denying access."), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            UtilTimerStack.pop((String)("DefaultSpacePermissionManager.hasPermission" + permissionCheck));
        }
    }

    private String getPermissionCheckAsString(String permissionType, Space space, User remoteUser) {
        if (!UtilTimerStack.isActive() && !log.isDebugEnabled()) {
            return "()";
        }
        return MessageFormat.format("({0}, {1}, {2})", permissionType, remoteUser != null ? remoteUser.getName() : "anonymous", space != null ? space.getKey() : "global");
    }

    public boolean hasPermission(List permissionTypes, Space space, User user) {
        for (int i = 0; i < permissionTypes.size(); ++i) {
            String permissionType = (String)permissionTypes.get(i);
            if (this.hasPermission(permissionType, space, user)) continue;
            return false;
        }
        return true;
    }

    public boolean groupHasPermission(String permissionType, Space space, String group) {
        SpacePermission constructedPermission = new SpacePermission(permissionType, space, group, null);
        if (!SpacePermission.getGenericSpacePermissions().contains(permissionType)) {
            constructedPermission.setSpace(null);
        }
        return this.permissionExists(constructedPermission);
    }

    public List getGlobalPermissions() {
        return this.spacePermissionDao.findAllGlobalPermissions();
    }

    public List getGlobalPermissions(String permissionType) {
        return this.spacePermissionDao.findAllGlobalPermissionsForType(permissionType);
    }

    public void removeAllUserPermissions(String username) {
        List permissions = this.getAllPermissionsForUser(username);
        this.removePermissions(permissions);
    }

    public void removeAllPermissionsForGroup(String group) {
        List permissions = this.getAllPermissionsForGroup(group);
        this.removePermissions(permissions);
    }

    protected void removePermissions(List permissions) {
        for (SpacePermission spacePermission : permissions) {
            this.removePermission(spacePermission);
        }
    }

    public List getAllPermissionsForGroup(String group) {
        return this.spacePermissionDao.findPermissionsForGroup(group);
    }

    protected List getAllPermissionsForUser(String username) {
        return this.spacePermissionDao.findPermissionsForUser(username);
    }

    public void removeAllPermissions(Space space) {
        this.spacePermissionDao.refresh(space);
        this.spacePermissionDao.removePermissionsForSpace(space);
        ArrayList spacePermissions = new ArrayList(space.getPermissions());
        Iterator iterator = spacePermissions.iterator();
        while (iterator.hasNext()) {
            space.removePermission((SpacePermission)iterator.next());
        }
    }

    public void createInitialSpacePermissions(Space space, User creator) {
        this.createInitialSpacePermissions(space);
    }

    public void createInitialSpacePermissions(Space space) {
        for (String permissionType : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
            SpacePermission permission = new SpacePermission(permissionType, space, null, space.getCreatorName());
            space.addPermission(permission);
            this.savePermission(permission);
        }
    }

    public Collection getUsersWithPermissions(Space space) {
        String permissionType = space == null ? "USECONFLUENCE" : "VIEWSPACE";
        ArrayList<User> result = new ArrayList<User>();
        Map users = this.getUsersForPermissionType(permissionType, space);
        for (String userName : users.keySet()) {
            User user = this.getUserAccessor().getUser(userName);
            result.add(user);
        }
        return result;
    }

    public Collection getGroupsWithPermissions(Space space) {
        String permissionType = space == null ? "USECONFLUENCE" : "VIEWSPACE";
        ArrayList<Group> result = new ArrayList<Group>();
        Map groups = this.getGroupsForPermissionType(permissionType, space);
        for (String groupName : groups.keySet()) {
            Group group = this.getUserAccessor().getGroup(groupName);
            result.add(group);
        }
        return result;
    }

    public Map getUsersForPermissionType(String permissionType, Space space) {
        Collator c = Collator.getInstance();
        c.setStrength(1);
        TreeMap<Object, Long> result = new TreeMap<Object, Long>(c);
        ArrayList permissions = space == null ? new ArrayList(this.getGlobalPermissions()) : new ArrayList(space.getPermissions());
        for (int i = 0; i < permissions.size(); ++i) {
            User user;
            String username;
            SpacePermission spacePermission = (SpacePermission)permissions.get(i);
            if (!spacePermission.isUserPermission() || !spacePermission.getType().equalsIgnoreCase(permissionType) || result.get(username = spacePermission.getUserName()) != null || (user = this.getUserAccessor().getUser(username)) == null) continue;
            result.put(username, new Long(spacePermission.getId()));
        }
        return result;
    }

    public Map getGroupsForPermissionType(String permissionType, Space space) {
        Collator c = Collator.getInstance();
        c.setStrength(1);
        TreeMap<Object, Long> result = new TreeMap<Object, Long>(c);
        ArrayList permissions = space == null ? new ArrayList(this.getGlobalPermissions()) : new ArrayList(space.getPermissions());
        for (SpacePermission spacePermission : permissions) {
            Group group;
            String groupName;
            if (!spacePermission.isGroupPermission() || !spacePermission.getType().equalsIgnoreCase(permissionType) || result.get(groupName = spacePermission.getGroup()) != null || (group = this.getUserAccessor().getGroup(groupName)) == null) continue;
            result.put(groupName, new Long(spacePermission.getId()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPermissionViaGroups(User user, Space space, String permissionType) {
        Pager pager;
        String permissionCheck = this.getPermissionCheckAsString(permissionType, space, user);
        UtilTimerStack.push((String)("hasPermissionViaGroups" + permissionCheck + ": retrieving groups"));
        try {
            pager = this.getUserAccessor().getGroups(user);
        }
        finally {
            UtilTimerStack.pop((String)("hasPermissionViaGroups" + permissionCheck + ": retrieving groups"));
        }
        if (pager == null) {
            return false;
        }
        for (Group g : pager) {
            if (g == null) {
                log.warn((Object)("null group returned by " + this.getUserAccessor().getClass()));
                continue;
            }
            String groupName = g.getName();
            UtilTimerStack.push((String)("hasPermissionViaGroups" + permissionCheck + ": checking permission for group (" + groupName + ")"));
            try {
                if (!this.groupHasPermission(permissionType, space, groupName)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                UtilTimerStack.pop((String)("hasPermissionViaGroups" + permissionCheck + ": checking permission for group (" + groupName + ")"));
            }
        }
        return false;
    }

    private boolean hasPermissionAsAnonymousUser(Space space, String permissionType) {
        SpacePermission permission = new SpacePermission(permissionType, space);
        if (space != null && !SpacePermission.getGenericSpacePermissions().contains(permissionType)) {
            permission.setSpace(null);
        }
        return this.permissionExists(permission);
    }

    private boolean hasPermissionAsUser(User user, Space space, String permissionType) {
        SpacePermission constructedPermission = new SpacePermission(permissionType, space, null, user.getName());
        if (!SpacePermission.getGenericSpacePermissions().contains(permissionType)) {
            constructedPermission.setSpace(null);
        }
        return this.permissionExists(constructedPermission);
    }

    public boolean permissionExists(SpacePermission permission) {
        if (permission.getSpace() != null && permission.getSpace().getId() == 0L) {
            return false;
        }
        if (permission.isSpacePermission()) {
            return permission.getSpace().getPermissions().contains(permission);
        }
        return this.spacePermissionDao.hasPermission(permission);
    }

    protected void savePermissionToDao(SpacePermission permission) {
        this.spacePermissionDao.save(permission);
    }

    protected void removePermissionFromDao(SpacePermission realPermission) {
        this.spacePermissionDao.remove(realPermission);
    }
}

