/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.PairType;
import com.atlassian.user.User;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DownloadGateKeeper
implements GateKeeper {
    private static Logger log = Logger.getLogger(DownloadGateKeeper.class);
    private static final Map permittedDownloads = Collections.synchronizedMap(new HashMap());
    private static final long ONE_DAY_MILLIS = 86400000L;

    public void addKey(String path, String username) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("gateKeeper.addKey(" + path + ", " + username));
        }
        if (path == null) {
            throw new IllegalArgumentException("The path is null. It must specify a file in " + GeneralUtil.getConfluenceTempDirectoryPath());
        }
        this.addPermission(path, username);
    }

    public void addKey(String path, User user) {
        this.addKey(path, this.getUserName(user));
    }

    public void allowAnonymousAccess(String path) {
        this.addPermission(path, null);
    }

    public boolean isAccessPermitted(String path, User user) {
        return this.isAccessPermitted(path, this.getUserName(user));
    }

    public boolean isAccessPermitted(String path, String userName) {
        this.runCheck();
        boolean result = permittedDownloads.containsKey(this.generateKey(userName, path));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Permission check for user '" + userName + "' and path '" + path + "' returned: " + result));
        }
        return result;
    }

    public void cleanAllKeys() {
        permittedDownloads.clear();
    }

    private void addPermission(String path, String userName) {
        try {
            int startIdx = path.indexOf("download");
            path = path.substring(startIdx);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("This download path does not contain the prefix 'download': " + path);
        }
        String key = this.generateKey(userName, path);
        PairType value = new PairType((Serializable)new Long(System.currentTimeMillis()), (Serializable)((Object)path));
        this.runCheck();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Putting key '" + key + "' into permittedDownloads."));
        }
        permittedDownloads.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCheck() {
        long now = System.currentTimeMillis();
        Collection downloads = permittedDownloads.values();
        Map map = permittedDownloads;
        synchronized (map) {
            Iterator iterator = downloads.iterator();
            while (iterator.hasNext()) {
                PairType value = (PairType)iterator.next();
                long downloadTimestamp = (Long)value.getKey();
                if (now - downloadTimestamp <= 86400000L) continue;
                iterator.remove();
            }
        }
    }

    private String generateKey(String userName, String path) {
        StringBuffer key = new StringBuffer();
        key.append(userName != null ? userName : "%anon%");
        key.append("|");
        key.append(path);
        return key.toString();
    }

    private String getUserName(User user) {
        return user != null ? user.getName() : null;
    }
}

