/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.DeactivatedUserChecker;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import org.apache.log4j.Logger;

public class LegacyDeactivatedUserChecker
implements DeactivatedUserChecker {
    private static Logger log = Logger.getLogger(LegacyDeactivatedUserChecker.class);
    private PropertySetFactory propertySetFactory;

    public boolean isDeactivated(User user) {
        PropertySet propertySet;
        if (user == null) {
            return false;
        }
        try {
            propertySet = this.propertySetFactory.getPropertySet((Entity)user);
        }
        catch (EntityException e) {
            log.error((Object)("There was an error retrieving the propertyset for the user: " + user), (Throwable)e);
            return false;
        }
        return propertySet != null && propertySet.getBoolean("confluence.user.deactivated");
    }

    public void setPropertySetFactory(PropertySetFactory propertySetFactory) {
        this.propertySetFactory = propertySetFactory;
    }
}

