/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.CacheManagerKeys;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.util.PairType;
import com.atlassian.user.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PermissionCheckDispatcherResultCache {
    private static Logger log = Logger.getLogger(PermissionCheckDispatcherResultCache.class);
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private Cache getCache() {
        return this.cacheManager.getCache(CacheManagerKeys.CACHE_KEY_PERMISSION_CHECK);
    }

    public Boolean getFromCache(String url) {
        String remoteUser = this.getRemoteUserNameForCacheKey();
        PairType cacheKey = new PairType((Serializable)((Object)remoteUser), (Serializable)((Object)url));
        Boolean result = (Boolean)this.getCache().get((Object)cacheKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking up in cache for " + remoteUser + " against " + url + " result: " + result));
        }
        return result;
    }

    public void putInCache(String url, boolean isPermitted) {
        String remoteUser = this.getRemoteUserNameForCacheKey();
        PairType cacheKey = new PairType((Serializable)((Object)remoteUser), (Serializable)((Object)url));
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding " + isPermitted + " to cache for " + remoteUser + " against " + url));
        }
        this.getCache().put((Object)cacheKey, (Object)isPermitted);
    }

    public void removeFromCache(String remoteUser) {
        if (remoteUser == null) {
            remoteUser = "";
        }
        try {
            Collection keys = this.getCache().getKeys();
            ArrayList<PairType> keysToRemove = new ArrayList<PairType>();
            for (PairType key : keys) {
                if (!key.getKey().equals(remoteUser)) continue;
                keysToRemove.add(key);
            }
            for (PairType cacheKey : keysToRemove) {
                this.getCache().remove((Object)cacheKey);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to flush permissions cache for user " + remoteUser + ". Flushing entire cache."), (Throwable)e);
            this.flush();
        }
    }

    public void flush() {
        try {
            this.getCache().removeAll();
        }
        catch (Exception e) {
            log.error((Object)"Could not flush permission check cache. Going into panic mode and attempting to clear all caches.", (Throwable)e);
            this.cacheManager.flushCaches();
        }
    }

    private String getRemoteUserNameForCacheKey() {
        User user = AuthenticatedUserThreadLocal.getUser();
        return user == null ? "" : user.getName();
    }
}

