/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.Group;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;

public class PermissionsFixer {
    private static final Category log = Category.getInstance(SpacePermissionManager.class);
    private SpacePermissionManager permissionManager;
    private UserAccessor userAccessor;

    public PermissionsFixer(SpacePermissionManager permissionManager, UserAccessor userAccessor) {
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
    }

    public void fixPermissions() throws Exception {
        log.info((Object)"Sanitizing Permissions");
        boolean groupExists = this.UsersGroupExists();
        if (!groupExists) {
            log.error((Object)"Permissions Cleaner: confluence-users group does not exist. You may have to fix your permissions manually.");
        } else {
            this.fixGlobalPermissions();
            this.fixSpacePermissions();
        }
        log.info((Object)"Finished sanitizing permissions");
    }

    private boolean UsersGroupExists() {
        Group usersGroup = this.getUsersGroup();
        return usersGroup != null;
    }

    private void fixGlobalPermissions() {
        List globalPermissions = this.permissionManager.getGlobalPermissions();
        this.fixPermissions(globalPermissions, null);
    }

    private void fixSpacePermissions() {
        SpaceManager spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
        List spaces = spaceManager.getAllSpaces();
        for (Space space : spaces) {
            this.fixPermissions(space.getPermissions(), space);
        }
    }

    private void fixPermissions(List permissions, Space space) {
        String guardPermission = space == null ? "USECONFLUENCE" : "VIEWSPACE";
        ArrayList missingGeneralUserPermissions = new ArrayList();
        ArrayList permissionsToAdd = new ArrayList();
        HashMap byGroup = new HashMap();
        HashMap byUser = new HashMap();
        this.sortPermissions(permissions, missingGeneralUserPermissions, byGroup, byUser);
        if (byGroup.containsKey("confluence-users")) {
            missingGeneralUserPermissions.removeAll((List)byGroup.get("confluence-users"));
        }
        this.prepareMissingGeneralUserPermissions(missingGeneralUserPermissions, permissionsToAdd, space, byGroup);
        this.prepareMissingGroupGuardPermissions(byGroup, guardPermission, permissionsToAdd, space);
        this.prepareMissingUserGuardPermissions(byUser, guardPermission, permissionsToAdd, space);
        for (SpacePermission permission : permissionsToAdd) {
            log.info((Object)("Updating permissions: adding " + permission));
            if (space != null) {
                space.addPermission(permission);
            }
            this.permissionManager.savePermission(permission);
        }
    }

    private void prepareMissingGroupGuardPermissions(Map byGroup, String guardPermission, List permissionsToAdd, Space space) {
        for (String groupName : byGroup.keySet()) {
            List types = (List)byGroup.get(groupName);
            if (types.contains(guardPermission)) continue;
            permissionsToAdd.add(new SpacePermission(guardPermission, space, groupName));
        }
    }

    private void prepareMissingUserGuardPermissions(Map byUser, String guardPermission, List permissionsToAdd, Space space) {
        for (String userName : byUser.keySet()) {
            List types = (List)byUser.get(userName);
            if (types.contains(guardPermission)) continue;
            permissionsToAdd.add(new SpacePermission(guardPermission, space, null, userName));
        }
    }

    private void prepareMissingGeneralUserPermissions(List missingGeneralUserPermissions, List permissionsToAdd, Space space, Map byGroup) {
        for (String permissionType : missingGeneralUserPermissions) {
            permissionsToAdd.add(new SpacePermission(permissionType, space, "confluence-users"));
            this.addToMapOfLists(byGroup, "confluence-users", permissionType);
        }
    }

    private void sortPermissions(List permissions, List permissionsRequired, Map byGroup, Map byUser) {
        for (SpacePermission permission : permissions) {
            if (permission.isAnonymousPermission()) {
                permissionsRequired.add(permission.getType());
            }
            if (permission.isGroupPermission()) {
                this.addToMapOfLists(byGroup, permission.getGroup(), permission.getType());
                continue;
            }
            if (!permission.isUserPermission()) continue;
            this.addToMapOfLists(byUser, permission.getUserName(), permission.getType());
        }
    }

    private Group getUsersGroup() {
        return this.userAccessor.getGroup("confluence-users");
    }

    private void addToMapOfLists(Map map, String key, String value) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
        ((List)map.get(key)).add(value);
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }
}

