/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class SpacePermissionCaseFixer {
    private static Logger log = Logger.getLogger(SpacePermissionCaseFixer.class);
    private final UserAccessor userAccessor;
    private final SpacePermissionManager spacePermissionManager;
    private final PrintWriter out;

    public SpacePermissionCaseFixer(UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, Writer out) {
        this.userAccessor = userAccessor;
        this.spacePermissionManager = spacePermissionManager;
        this.out = new PrintWriter(out);
    }

    public void fix(SpacePermission spacePermission) throws IOException {
        if (spacePermission.isGroupPermission()) {
            String groupName = spacePermission.getGroup();
            if (groupName == null) {
                return;
            }
            Group group = this.userAccessor.getGroup(groupName);
            if (group == null) {
                group = this.userAccessor.getGroup(groupName.toLowerCase());
            }
            if (group == null) {
                return;
            }
            if (!group.getName().equals(groupName) && group.getName().equalsIgnoreCase(groupName)) {
                spacePermission.setGroup(group.getName());
                try {
                    this.spacePermissionManager.savePermission(spacePermission);
                    this.out.println("Fixed " + spacePermission + "<br/>");
                }
                catch (RuntimeException e) {
                    this.out.println("Error occurred trying to update a SpacePermission for group: " + groupName + ":" + e);
                    log.error((Object)("Error occurred trying to update a SpacePermission for group: " + groupName), (Throwable)e);
                }
            }
        } else {
            String userName = spacePermission.getUserName();
            if (userName == null) {
                return;
            }
            User user = this.userAccessor.getUser(userName);
            if (user == null) {
                user = this.userAccessor.getUser(userName.toLowerCase());
            }
            if (user == null) {
                return;
            }
            if (!user.getName().equals(userName) && user.getName().equalsIgnoreCase(userName)) {
                spacePermission.setUserName(user.getName());
                try {
                    this.spacePermissionManager.savePermission(spacePermission);
                    this.out.println("Fixed " + spacePermission + "<br/>");
                }
                catch (RuntimeException e) {
                    this.out.println("Error occurred trying to update a SpacePermission for user: " + userName + ":" + e);
                    log.error((Object)("Error occurred trying to update a SpacePermission for user: " + userName), (Throwable)e);
                }
            }
        }
    }
}

