/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.actions;

import com.atlassian.confluence.security.EntityRuntimeException;
import com.atlassian.confluence.security.PermissionCheckDispatcherResultCache;
import com.atlassian.confluence.security.SetSpacePermissionChecker;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.actions.AbstractViewPermissionsAction;
import com.atlassian.confluence.security.actions.EditPermissionsHelper;
import com.atlassian.confluence.user.SearchEntitiesManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractEditPermissionsAction
extends AbstractViewPermissionsAction {
    private static final Logger log = Logger.getLogger(AbstractEditPermissionsAction.class);
    private static final Integer MAX_ENTRIES = new Integer(20);
    private PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache;
    private String usersToAdd;
    private String groupsToAdd;
    private SearchEntitiesManager searchEntitiesManager;
    private SetSpacePermissionChecker setSpacePermissionChecker;

    public void validate() {
        int numberOfUserEntries;
        int numberOfGroupEntries;
        super.validate();
        if (this.getRequestParams().containsKey("groupsToAddButton") && !TextUtils.stringSet((String)this.getGroupsToAdd())) {
            this.addFieldError("groupsToAdd", this.getText("groups.to.add.empty"));
        }
        if ((numberOfGroupEntries = this.countEntries(this.getGroupsToAdd())) > MAX_ENTRIES) {
            this.addFieldError("groupsToAdd", this.getText("groups.to.add.too.many.entries", new Object[]{new Integer(numberOfGroupEntries), MAX_ENTRIES}));
        }
        if (this.getRequestParams().containsKey("usersToAddButton") && !TextUtils.stringSet((String)this.getUsersToAdd())) {
            this.addFieldError("usersToAdd", this.getText("users.to.add.empty"));
        }
        if ((numberOfUserEntries = this.countEntries(this.getUsersToAdd())) > MAX_ENTRIES) {
            this.addFieldError("usersToAdd", this.getText("users.to.add.too.many.entries", new Object[]{new Integer(numberOfUserEntries), MAX_ENTRIES}));
        }
    }

    private int countEntries(String entries) {
        return StringUtils.countMatches((String)entries, (String)",") + 1;
    }

    public String execute() throws Exception {
        Collection requestedPermissionsFromForm;
        Collection initialPermissionsFromForm;
        EditPermissionsHelper helper = new EditPermissionsHelper();
        HashSet permissionsToRemove = new HashSet();
        HashSet permissionsToAdd = new HashSet();
        if (this.getSpace() == null) {
            initialPermissionsFromForm = helper.buildGlobalPermissionsFromWebForm(this.getRequestParams(), "initial");
            requestedPermissionsFromForm = helper.buildGlobalPermissionsFromWebForm(this.getRequestParams(), "checkbox");
        } else {
            initialPermissionsFromForm = helper.buildSpacePermissionsFromWebForm(this.getSpace(), this.getRequestParams(), "initial");
            requestedPermissionsFromForm = helper.buildSpacePermissionsFromWebForm(this.getSpace(), this.getRequestParams(), "checkbox");
        }
        List currentPermissions = this.getPermissions();
        helper.splitPermissions(currentPermissions, initialPermissionsFromForm, requestedPermissionsFromForm, permissionsToAdd, permissionsToRemove);
        this.denyRemoveAllAdminPermissions(permissionsToRemove);
        if (this.settingsManager.getGlobalSettings().isSharedMode() && !this.isAdminUser()) {
            this.denyAnonymousPermissions(initialPermissionsFromForm, permissionsToAdd, permissionsToRemove);
        }
        if (this.getActionErrors().size() > 0) {
            return "error";
        }
        Iterator it = permissionsToAdd.iterator();
        while (it.hasNext()) {
            this.addPermission((SpacePermission)it.next());
        }
        for (SpacePermission spacePermission : permissionsToRemove) {
            if (this.isPersonalSpaceOwner(spacePermission)) continue;
            this.removePermission(spacePermission);
        }
        String groupNamesToBeAdded = this.getGroupsToAdd();
        if (TextUtils.stringSet((String)groupNamesToBeAdded)) {
            this.addGuardPermissionToGroups(groupNamesToBeAdded);
            return this.getAdjustReturn();
        }
        String userNamesToBeAdded = this.getUsersToAdd();
        if (TextUtils.stringSet((String)userNamesToBeAdded)) {
            this.addGuardPermissionToUsers(userNamesToBeAdded);
            return this.getAdjustReturn();
        }
        this.permissionCheckDispatcherResultCache.flush();
        return "success";
    }

    private boolean isPersonalSpaceOwner(SpacePermission spacePermission) {
        return this.getSpace() != null && this.getSpace().isPersonal() && spacePermission.isUserPermission() && spacePermission.getUserName().equals(this.getSpace().getCreatorName());
    }

    private String getAdjustReturn() {
        if (this.getFieldErrors().isEmpty()) {
            return "adjust";
        }
        return "input";
    }

    private String getUsersToAdd() {
        return this.usersToAdd;
    }

    public void setUsersToAdd(String usersToAdd) {
        this.usersToAdd = usersToAdd;
    }

    private String getGroupsToAdd() {
        return this.groupsToAdd;
    }

    public void setGroupsToAdd(String groupsToAdd) {
        this.groupsToAdd = groupsToAdd;
    }

    protected abstract String getAdministrativePermissionType();

    private void addGuardPermissionToUsers(String userNames) {
        String[] userNamesForViewable = GeneralUtil.splitCommaDelimitedString(userNames);
        for (int i = 0; i < userNamesForViewable.length; ++i) {
            userNamesForViewable[i] = userNamesForViewable[i].trim();
            User user = this.getUserIfAvailable(userNamesForViewable[i]);
            if (user != null) {
                this.addPermission(new SpacePermission(this.getGuardPermission(), this.getSpace(), null, user.getName()));
                continue;
            }
            this.addFieldError("usersToAdd", this.getText("user.could.not.be.found", new Object[]{GeneralUtil.htmlEncode(userNamesForViewable[i])}));
        }
    }

    private User getUserIfAvailable(String username) {
        User user = this.userAccessor.getUser(username);
        boolean available = true;
        if (this.settingsManager.getGlobalSettings().isSharedMode() && user != null) {
            try {
                List usersFound = this.searchEntitiesManager.findUsersAsList((Query)new UserNameTermQuery(username));
                this.userAccessor.filterUnaccessibleUsers(usersFound, this.getRemoteUser());
                available = usersFound.contains(user);
            }
            catch (EntityException e) {
                log.error((Object)"Couldn't find user", (Throwable)e);
                available = false;
            }
        }
        if (available) {
            return user;
        }
        return null;
    }

    private boolean isUserAvailable(String username) {
        User user = this.getUserIfAvailable(username);
        return user != null;
    }

    private void addGuardPermissionToGroups(String groupNames) {
        String[] groupNamesForViewable = GeneralUtil.splitCommaDelimitedString(groupNames);
        for (int i = 0; i < groupNamesForViewable.length; ++i) {
            groupNamesForViewable[i] = groupNamesForViewable[i].trim();
            Group group = this.getGroupIfAvailable(groupNamesForViewable[i]);
            if (group != null) {
                this.addPermission(new SpacePermission(this.getGuardPermission(), this.getSpace(), group.getName()));
                continue;
            }
            this.addFieldError("groupsToAdd", this.getText("group.could.not.be.found", new Object[]{GeneralUtil.htmlEncode(groupNamesForViewable[i])}));
        }
    }

    private Group getGroupIfAvailable(String groupname) {
        Group group = this.userAccessor.getGroup(groupname);
        boolean available = true;
        if (this.settingsManager.getGlobalSettings().isSharedMode() && group != null) {
            try {
                List groupsFound = this.searchEntitiesManager.findGroupsAsList((TermQuery)new GroupNameTermQuery(groupname), true);
                available = groupsFound.contains(group);
            }
            catch (EntityException e) {
                log.error((Object)"Couldn't find group", (Throwable)e);
                available = false;
            }
        }
        if (available) {
            return group;
        }
        return null;
    }

    private boolean isGroupAvailable(String groupname) {
        return this.getGroupIfAvailable(groupname) != null;
    }

    private void denyRemoveAllAdminPermissions(Set permissionsToRemove) {
        if (permissionsToRemove.isEmpty()) {
            return;
        }
        List adminPermissionsBeingRemoved = this.getAdministrationPermissions(permissionsToRemove);
        List existingAdministrationPermissions = this.getAdministrationPermissions(this.getPermissions());
        if (adminPermissionsBeingRemoved.size() == existingAdministrationPermissions.size() && existingAdministrationPermissions.size() > 0) {
            if (this.getSpace() != null) {
                this.addActionError(this.getText("error.cannot.remove.all.admin.permissions.for.space"));
            } else {
                this.addActionError(this.getText("error.cannot.remove.all.admin.permissions"));
            }
        }
    }

    private List getAdministrationPermissions(Collection permissions) {
        ArrayList<SpacePermission> result = new ArrayList<SpacePermission>();
        for (SpacePermission spacePermission : permissions) {
            if (!spacePermission.getType().equals(this.getAdministrativePermissionType())) continue;
            result.add(spacePermission);
        }
        return result;
    }

    private void denyAnonymousPermissions(Collection currentPermissions, Set permissionsToAdd, Set permissionsToRemove) {
        for (SpacePermission perm : currentPermissions) {
            if (!perm.isAnonymousPermission()) continue;
            permissionsToRemove.add(perm);
        }
        Iterator iterator = permissionsToAdd.iterator();
        while (iterator.hasNext()) {
            SpacePermission perm;
            perm = (SpacePermission)iterator.next();
            if (!perm.isAnonymousPermission()) continue;
            iterator.remove();
        }
    }

    protected void addPermission(SpacePermission permission) {
        if (!this.isPermissionExists(permission) && !permission.isInvalidAnonymousPermission() && this.setSpacePermissionChecker.canSetPermission(this.getRemoteUser(), permission)) {
            if (this.getSpace() != null) {
                this.getSpace().addPermission(permission);
            } else {
                this.getPermissions().add(permission);
            }
            this.spacePermissionManager.savePermission(permission);
        }
    }

    protected boolean isPermissionExists(SpacePermission spacePermission) {
        return this.getPermissions().contains(spacePermission);
    }

    public String buildUserCheckboxName(String permissionType, String username) {
        return new SpacePermission(permissionType, this.getSpace(), null, username).toFormParameterName("checkbox");
    }

    public String buildUserHiddenInputName(String permissionType, String username) {
        return new SpacePermission(permissionType, this.getSpace(), null, username).toFormParameterName("initial");
    }

    public String buildGroupCheckboxName(String permissionType, String groupName) {
        return new SpacePermission(permissionType, this.getSpace(), groupName).toFormParameterName("checkbox");
    }

    public String buildGroupHiddenInputName(String permissionType, String groupName) {
        return new SpacePermission(permissionType, this.getSpace(), groupName).toFormParameterName("initial");
    }

    public String buildAnonymousCheckboxName(String permissionType) {
        return new SpacePermission(permissionType, this.getSpace(), null, null).toFormParameterName("checkbox");
    }

    public String buildAnonymousHiddenInputName(String permissionType) {
        return new SpacePermission(permissionType, this.getSpace(), null, null).toFormParameterName("initial");
    }

    protected Map getRequestParams() {
        return ServletActionContext.getRequest().getParameterMap();
    }

    protected void removePermission(SpacePermission permissionToRemove) {
        if (this.setSpacePermissionChecker.canSetPermission(this.getRemoteUser(), permissionToRemove)) {
            this.getPermissions().remove(permissionToRemove);
            this.spacePermissionManager.removePermission(permissionToRemove);
        }
    }

    public boolean canSetSystemAdministratorPermission() {
        return this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, this.getRemoteUser());
    }

    public boolean canSetPermissionOnUser(String permission, String username) {
        if (!SpacePermission.GLOBAL_PERMISSIONS.contains(permission.toUpperCase())) {
            throw new IllegalArgumentException("Unknown global permission: " + permission);
        }
        try {
            return this.setSpacePermissionChecker.canSetPermission(this.getRemoteUser(), new SpacePermission(permission, null, null, username));
        }
        catch (EntityRuntimeException e) {
            log.error((Object)("Error determining whether a permission can be set on user: " + username), (Throwable)e);
            return false;
        }
    }

    public boolean canSetPermissionOnGroup(String permission, String groupName) {
        if (!SpacePermission.GLOBAL_PERMISSIONS.contains(permission.toUpperCase())) {
            throw new IllegalArgumentException("Unknown global permission: " + permission);
        }
        try {
            return this.setSpacePermissionChecker.canSetPermission(this.getRemoteUser(), new SpacePermission(permission, null, groupName));
        }
        catch (EntityRuntimeException e) {
            log.error((Object)("Error determining whether a permission can be set on group: " + groupName), (Throwable)e);
            return false;
        }
    }

    public PermissionCheckDispatcherResultCache getPermissionCheckDispatcherResultCache() {
        return this.permissionCheckDispatcherResultCache;
    }

    public void setPermissionCheckDispatcherResultCache(PermissionCheckDispatcherResultCache permissionCheckDispatcherResultCache) {
        this.permissionCheckDispatcherResultCache = permissionCheckDispatcherResultCache;
    }

    public void setSearchEntitiesManager(SearchEntitiesManager searchEntitiesManager) {
        this.searchEntitiesManager = searchEntitiesManager;
    }

    public void setSetSpacePermissionChecker(SetSpacePermissionChecker setSpacePermissionChecker) {
        this.setSpacePermissionChecker = setSpacePermissionChecker;
    }
}

