/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.actions;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.List;

public abstract class AbstractSpacePermissionsAction
extends AbstractSpaceAction {
    protected List permissions;

    public List getPermissions() {
        if (this.permissions == null) {
            this.permissions = this.getSpace() != null ? this.getSpace().getPermissions() : this.spacePermissionManager.getGlobalPermissions();
        }
        return this.permissions;
    }

    public boolean isAnonymousSpacePermissionWithoutGlobalPermission() {
        return this.getSpace() != null && this.spacePermissionManager.hasPermission("VIEWSPACE", this.getSpace(), null) && !this.spacePermissionManager.hasPermission("USECONFLUENCE", null, null);
    }

    public boolean isPermitted() {
        if (GeneralUtil.isSuperUser(this.getRemoteUser())) {
            return true;
        }
        if (this.getSpace() != null) {
            return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, this.getSpace());
        }
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }
}

