/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.actions;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.actions.AbstractSpacePermissionsAction;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractViewPermissionsAction
extends AbstractSpacePermissionsAction {
    protected List groups;
    protected List groupNames;
    protected List selectedPermissions = new ArrayList();
    protected List selectedGroups = new ArrayList();
    protected List selectedUsers = new ArrayList();
    protected List permissions;
    protected long permissionId;
    protected String selectedUsername;
    protected String selectedGroup;
    protected int startIndex;
    protected Map userPermissionRows;
    protected Map groupPermissionRows;
    protected PermissionRow anonymousPermissionRow;

    public Collection getUserPermissionRows() {
        if (this.userPermissionRows == null) {
            this.buildUserPermissionTable();
        }
        return this.userPermissionRows.values();
    }

    public Collection getGroupPermissionRows() {
        if (this.groupPermissionRows == null) {
            this.buildGroupPermissionTable();
        }
        return this.groupPermissionRows.values();
    }

    public PermissionRow getAnonymousPermissionRow() {
        if (this.anonymousPermissionRow == null) {
            this.anonymousPermissionRow = new AnonymousPermissionRow();
            for (SpacePermission spacePermission : this.getPermissions()) {
                if (!spacePermission.isAnonymousPermission()) continue;
                this.anonymousPermissionRow.addPermissionType(spacePermission);
            }
        }
        return this.anonymousPermissionRow;
    }

    private void buildUserPermissionTable() {
        this.userPermissionRows = new TreeMap();
        for (SpacePermission spacePermission : this.getPermissions()) {
            if (!spacePermission.isUserPermission()) continue;
            String username = spacePermission.getUserName();
            PermissionRow permissionRow = (PermissionRow)this.userPermissionRows.get(username);
            if (permissionRow == null) {
                permissionRow = new UserPermissionRow(username, this.userAccessor);
                this.userPermissionRows.put(username, permissionRow);
            }
            permissionRow.addPermissionType(spacePermission);
        }
    }

    private void buildGroupPermissionTable() {
        this.groupPermissionRows = new TreeMap();
        for (SpacePermission spacePermission : this.getPermissions()) {
            if (!spacePermission.isGroupPermission()) continue;
            String groupName = spacePermission.getGroup();
            PermissionRow permissionRow = (PermissionRow)this.groupPermissionRows.get(groupName);
            if (permissionRow == null) {
                permissionRow = new GroupPermissionRow(groupName, this.userAccessor);
                this.groupPermissionRows.put(groupName, permissionRow);
            }
            permissionRow.addPermissionType(spacePermission);
        }
    }

    public List getAnonymousPermissions() {
        ArrayList<SpacePermission> result = new ArrayList<SpacePermission>();
        for (SpacePermission spacePermission : this.getPermissions()) {
            if (!spacePermission.isAnonymousPermission()) continue;
            result.add(spacePermission);
        }
        return result;
    }

    public boolean hasGroupPermission(String group, String permissionType) {
        return this.spacePermissionManager.getGroupsForPermissionType(permissionType, this.getSpace()).containsKey(group);
    }

    public boolean hasUserPermission(User user, String permissionType) {
        if (user == null) {
            return false;
        }
        for (SpacePermission spacePermission : this.getPermissions()) {
            if (!spacePermission.isUserPermission() || !spacePermission.getUserName().equals(user.getName()) || !spacePermission.getType().equals(permissionType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnonymousPermission(String permissionType) {
        for (SpacePermission spacePermission : this.getAnonymousPermissions()) {
            if (!spacePermission.getType().equalsIgnoreCase(permissionType)) continue;
            return true;
        }
        return false;
    }

    public List getActiveUsers() {
        ArrayList<String> result = new ArrayList<String>();
        for (SpacePermission spacePermission : this.getPermissions()) {
            if (!spacePermission.isUserPermission() || !this.getGuardPermission().equals(spacePermission.getType())) continue;
            result.add(spacePermission.getUserName());
        }
        Collections.sort(result);
        return result;
    }

    public List getActiveGroups() {
        ArrayList result = new ArrayList();
        Iterator iterator = this.spacePermissionManager.getGroupsForPermissionType(this.getGuardPermission(), this.getSpace()).keySet().iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        Collections.sort(result);
        return result;
    }

    public String getSelectedUsername() {
        return this.selectedUsername;
    }

    public void setSelectedUsername(String selectedUsername) {
        this.selectedUsername = selectedUsername;
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(String selectedGroup) {
        this.selectedGroup = selectedGroup;
    }

    protected abstract String getGuardPermission();

    public boolean isSharedMode() {
        return this.settingsManager.getGlobalSettings().isSharedMode();
    }

    public static class AnonymousPermissionRow
    extends PermissionRow {
        public String buildParameterName(String permissionType, String inputType) {
            StringBuffer result = new StringBuffer("confluence_").append(inputType).append("_");
            result.append(permissionType.toLowerCase(Locale.ENGLISH)).append("_");
            result.append("anonymous");
            return result.toString();
        }

        public boolean entityExists() {
            return true;
        }

        public boolean isCaseInvalid() {
            return false;
        }
    }

    public static class GroupPermissionRow
    extends PermissionRow {
        private final String groupName;
        private final Group group;

        public GroupPermissionRow(String permissionGroupName, UserAccessor userAccessor) {
            this.groupName = permissionGroupName;
            this.group = userAccessor.getGroup(permissionGroupName);
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String buildParameterName(String permissionType, String inputType) {
            StringBuffer result = new StringBuffer("confluence_").append(inputType).append("_");
            result.append(permissionType.toLowerCase(Locale.ENGLISH)).append("_");
            result.append("group_").append(this.groupName);
            return result.toString();
        }

        public boolean entityExists() {
            return this.group != null;
        }

        public boolean isCaseInvalid() {
            return this.group != null && !this.group.getName().equals(this.groupName);
        }

        public Group getGroup() {
            return this.group;
        }
    }

    public static class UserPermissionRow
    extends PermissionRow {
        private final String username;
        private final User user;

        public UserPermissionRow(String permissionUsername, UserAccessor userAccessor) {
            this.username = permissionUsername;
            this.user = userAccessor.getUser(permissionUsername);
        }

        public String getUsername() {
            return this.username;
        }

        public String buildParameterName(String permissionType, String inputType) {
            StringBuffer result = new StringBuffer("confluence_").append(inputType).append("_");
            result.append(permissionType.toLowerCase(Locale.ENGLISH)).append("_");
            result.append("user_").append(this.username);
            return result.toString();
        }

        public boolean entityExists() {
            return this.user != null;
        }

        public boolean isCaseInvalid() {
            return this.user != null && !this.user.getName().equals(this.username);
        }

        public User getUser() {
            return this.user;
        }
    }

    public static abstract class PermissionRow {
        private final Map includedPermissions = new HashMap();

        public void addPermissionType(SpacePermission permission) {
            this.includedPermissions.put(permission.getType(), permission);
        }

        public boolean isTypeAllowed(String permissionType) {
            return this.includedPermissions.containsKey(permissionType.toUpperCase());
        }

        public SpacePermission getPermission(String permissionType) {
            return (SpacePermission)this.includedPermissions.get(permissionType.toUpperCase());
        }

        public String buildCheckboxParameterName(String permissionType) {
            return this.buildParameterName(permissionType, "checkbox");
        }

        public String buildHiddenParameterName(String permissionType) {
            return this.buildParameterName(permissionType, "initial");
        }

        public abstract String buildParameterName(String var1, String var2);

        public abstract boolean entityExists();

        public abstract boolean isCaseInvalid();
    }
}

