/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.actions;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;

public class EditPermissionsHelper {
    public static final Category log = Category.getInstance(EditPermissionsHelper.class);
    public static final String PARAMETER_PREFIX = "confluence_";

    public void updatePermissions(Map parameters) {
    }

    public Collection buildGlobalPermissionsFromWebForm(Map formParameters, String parameterQualifier) {
        return this.buildPermissionsFromWebForm(null, formParameters, parameterQualifier);
    }

    public Collection buildSpacePermissionsFromWebForm(Space space, Map formParameters, String parameterQualifier) {
        if (space == null) {
            throw new IllegalArgumentException("Space can not be null");
        }
        return this.buildPermissionsFromWebForm(space, formParameters, parameterQualifier);
    }

    private Collection buildPermissionsFromWebForm(Space space, Map formParameters, String parameterQualifier) {
        ArrayList<SpacePermission> permissions = new ArrayList<SpacePermission>();
        String expectedPrefix = PARAMETER_PREFIX + parameterQualifier + "_";
        for (Map.Entry entry : formParameters.entrySet()) {
            if (!((String)entry.getKey()).startsWith(expectedPrefix)) continue;
            try {
                permissions.add(SpacePermission.fromFormParameterName((String)entry.getKey(), space, parameterQualifier));
            }
            catch (ParseException e) {
                log.debug((Object)("Unrecognised space permission parameter: " + e.getMessage()), (Throwable)e);
            }
        }
        return permissions;
    }

    public void splitPermissions(Collection existingPermissions, Collection initialPermissions, Collection requestedPermissions, Set permissionsToAdd, Set permissionsToRemove) {
        ArrayList<SpacePermission> removedGuardPermissions = new ArrayList<SpacePermission>();
        permissionsToAdd.addAll(requestedPermissions);
        permissionsToAdd.removeAll(initialPermissions);
        permissionsToAdd.removeAll(existingPermissions);
        for (SpacePermission spacePermission : existingPermissions) {
            if (!initialPermissions.contains(spacePermission) || requestedPermissions.contains(spacePermission)) continue;
            permissionsToRemove.add(spacePermission);
            removedGuardPermissions.add(spacePermission);
        }
        this.removeDependentPermissions(removedGuardPermissions, existingPermissions, permissionsToAdd, permissionsToRemove);
    }

    private void removeDependentPermissions(List removedGuardPermissions, Collection existingPermissions, Set permissionsToAdd, Set permissionsToRemove) {
        for (SpacePermission guardPermission : removedGuardPermissions) {
            Iterator it2 = permissionsToAdd.iterator();
            while (it2.hasNext()) {
                if (!((SpacePermission)it2.next()).isDependentOn(guardPermission)) continue;
                it2.remove();
            }
            for (SpacePermission existingPermission : existingPermissions) {
                if (!existingPermission.isDependentOn(guardPermission)) continue;
                permissionsToRemove.add(existingPermission);
            }
        }
    }
}

