/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.actions.LoginAction;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class NotPermittedAction
extends LoginAction {
    private static final Logger log = Logger.getLogger(NotPermittedAction.class);
    private String key;
    private SpaceManager spaceManager;

    public String execute() throws Exception {
        this.setFromNotPermitted(true);
        HttpServletRequest request = ServletActionContext.getRequest();
        if (!TextUtils.stringSet((String)((String)request.getAttribute("atlassian.core.seraph.original.url")))) {
            String originalURL = request.getServletPath() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
            request.setAttribute("atlassian.core.seraph.original.url", (Object)originalURL);
            if (log.isDebugEnabled()) {
                log.debug((Object)("No atlassian.core.seraph.original.url was found in the request. Storing " + originalURL));
            }
        }
        if (this.getRemoteUser() == null) {
            return "login";
        }
        return "success";
    }

    public String getLoginUrl() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String loginURL = SeraphUtils.getLoginURL(request);
        String contextPath = TextUtils.noNull((String)request.getContextPath());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Seraph login.url is " + loginURL));
        }
        if (TextUtils.stringSet((String)contextPath) && TextUtils.noNull((String)loginURL).startsWith(contextPath)) {
            loginURL = loginURL.substring(contextPath.length());
        }
        return loginURL;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Space getSpace() {
        return this.spaceManager.getSpace(this.getKey());
    }

    public String getUsername() {
        if (this.getSpace() != null && this.getSpace().getCreatorName() != null) {
            User user = this.userAccessor.getUser(this.getSpace().getCreatorName());
            return user.getFullName();
        }
        return null;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

