/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.user.User;

public class AttachmentPermissionsDelegate
extends AbstractPermissionsDelegate {
    private PermissionManager permissionManager;
    private ContentPermissionManager contentPermissionManager;

    public boolean canView(User user, Object target) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, ((Attachment)target).getContent());
    }

    public boolean canEdit(User user, Object target) {
        return this.permissionManager.hasPermission(user, Permission.EDIT, ((Attachment)target).getContent());
    }

    public boolean canSetPermissions(User user, Object target) {
        throw new IllegalStateException("Permission-setting privileges do not apply to comments");
    }

    public boolean canRemove(User user, Object target) {
        ContentEntityObject container = ((Attachment)target).getContent();
        if (container instanceof PersonalInformation) {
            return ((PersonalInformation)container).getUsername().equals(user.getName());
        }
        if (container instanceof SpaceContentEntityObject) {
            return this.hasSpaceLevelPermission("REMOVEATTACHMENT", user, target) && this.contentPermissionManager.hasContentLevelPermission(user, "Edit", ((Attachment)target).getContent());
        }
        throw new IllegalStateException("Did not expect to find an attachment inside a " + container.getClass());
    }

    public boolean canExport(User user, Object target) {
        throw new IllegalStateException("Export privileges do not apply to attachments");
    }

    public boolean canAdminister(User user, Object target) {
        throw new IllegalStateException("Administration privileges do not apply to attachments");
    }

    public boolean canCreate(User user, Object container) {
        if (container instanceof PersonalInformation) {
            return ((PersonalInformation)container).getUsername().equals(user.getName()) && this.spacePermissionManager.hasPermission("PROFILEATTACHMENTS", null, user);
        }
        if (container instanceof User) {
            return container.equals(user) && this.spacePermissionManager.hasPermission("PROFILEATTACHMENTS", null, user);
        }
        if (container instanceof SpaceContentEntityObject) {
            return this.contentPermissionManager.hasContentLevelPermission(user, "Edit", (SpaceContentEntityObject)container) && this.spacePermissionManager.hasPermission("CREATEATTACHMENT", ((SpaceContentEntityObject)container).getSpace(), user);
        }
        if (container instanceof Space) {
            return this.spacePermissionManager.hasPermission("CREATEATTACHMENT", (Space)container, user);
        }
        if (container instanceof Comment) {
            return false;
        }
        throw new IllegalStateException("Attachments can not be created inside " + container.getClass());
    }

    public void setPermissionManagerTarget(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    protected Space getSpaceFrom(Object target) {
        ContentEntityObject entity = ((Attachment)target).getContent();
        return entity instanceof SpaceContentEntityObject ? ((SpaceContentEntityObject)entity).getSpace() : null;
    }
}

