/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;

public class PagePermissionsDelegate
extends AbstractPermissionsDelegate {
    private ContentPermissionManager contentPermissionManager;

    public boolean canView(User user, Object target) {
        return this.hasSpaceLevelPermission("VIEWSPACE", user, target) && this.hasContentLevelViewPermission(user, target);
    }

    public boolean canEdit(User user, Object target) {
        return this.canView(user, target) && this.hasSpaceLevelPermission("EDITSPACE", user, target) && this.hasContentLevelEditPermission(user, target);
    }

    public boolean canSetPermissions(User user, Object target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target) || this.hasContentLevelEditPermission(user, target) && this.hasSpaceLevelPermission("SETPAGEPERMISSIONS", user, target);
    }

    public boolean canRemove(User user, Object target) {
        return this.hasContentLevelEditPermission(user, target) && this.hasSpaceLevelPermission("REMOVEPAGE", user, target);
    }

    public boolean canExport(User user, Object target) {
        return this.hasContentLevelViewPermission(user, target) && this.hasSpaceLevelPermission("EXPORTPAGE", user, target);
    }

    public boolean canAdminister(User user, Object target) {
        throw new IllegalStateException("Administration privileges do not apply to pages");
    }

    private boolean hasContentLevelViewPermission(User user, Object target) {
        return this.contentPermissionManager.hasContentLevelPermission(user, "View", (ContentEntityObject)target);
    }

    private boolean hasContentLevelEditPermission(User user, Object target) {
        return this.contentPermissionManager.hasContentLevelPermission(user, "Edit", (ContentEntityObject)target);
    }

    public void setContentPermissionManager(ContentPermissionManager contentPermissionManager) {
        this.contentPermissionManager = contentPermissionManager;
    }

    public boolean canCreate(User user, Object container) {
        return this.spacePermissionManager.hasPermission("EDITSPACE", (Space)container, user);
    }

    protected Space getSpaceFrom(Object target) {
        return ((AbstractPage)target).getSpace();
    }
}

