/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.delegate.AbstractPermissionsDelegate;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.user.User;

public class SpacePermissionsDelegate
extends AbstractPermissionsDelegate {
    public boolean canView(User user, Object target) {
        return this.hasSpaceLevelPermission("VIEWSPACE", user, target);
    }

    public boolean canEdit(User user, Object target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    public boolean canSetPermissions(User user, Object target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    public boolean canRemove(User user, Object target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    public boolean canExport(User user, Object target) {
        return this.hasSpaceLevelPermission("EXPORTSPACE", user, target);
    }

    public boolean canAdminister(User user, Object target) {
        return this.hasSpaceLevelPermission("SETSPACEPERMISSIONS", user, target);
    }

    public boolean canCreate(User user, Object container) {
        if (PermissionManager.TARGET_APPLICATION.equals(container)) {
            return this.spacePermissionManager.hasPermission("CREATESPACE", null, user);
        }
        if (container instanceof PersonalInformation) {
            return this.spacePermissionManager.hasPermission("PERSONALSPACE", null, user);
        }
        throw new IllegalArgumentException("Can only create spaces within the application, or for a user");
    }

    protected Space getSpaceFrom(Object target) {
        return (Space)target;
    }
}

