/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.delegate;

import com.atlassian.confluence.security.PermissionDelegate;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.user.User;

public class UserPermissionsDelegate
implements PermissionDelegate {
    private SpacePermissionManager spacePermissionManager;

    public boolean canView(User user, Object target) {
        return true;
    }

    public boolean canEdit(User user, Object target) {
        if (this.isAnonymous(user)) {
            return false;
        }
        if (target.equals(user)) {
            return true;
        }
        return this.hasRelevantAdministrativePermissions(user, (User)target);
    }

    public boolean canRemove(User user, Object target) {
        if (this.isAnonymous(user)) {
            return false;
        }
        return this.hasRelevantAdministrativePermissions(user, (User)target);
    }

    public boolean canCreate(User user, Object container) {
        if (this.isAnonymous(user)) {
            return false;
        }
        return this.spacePermissionManager.hasPermission("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, user);
    }

    public boolean canExport(User user, Object target) {
        throw new UnsupportedOperationException("Export privileges do not apply to users");
    }

    public boolean canSetPermissions(User user, Object target) {
        return this.hasRelevantAdministrativePermissions(user, (User)target);
    }

    public boolean canAdminister(User user, Object target) {
        throw new UnsupportedOperationException("Administer privileges is undefined for users and hence does not apply.");
    }

    private boolean hasRelevantAdministrativePermissions(User user, User targetUser) {
        if (this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, targetUser)) {
            return this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, user);
        }
        return this.spacePermissionManager.hasPermission("ADMINISTRATECONFLUENCE", null, user) || this.spacePermissionManager.hasPermission("SYSTEMADMINISTRATOR", null, user);
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    private boolean isAnonymous(User user) {
        return user == null;
    }
}

