/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.interceptors;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.setup.webwork.AbstractAwareInterceptor;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;
import javax.servlet.http.HttpSession;

public class CaptchaInterceptor
extends AbstractAwareInterceptor {
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        Action action = actionInvocation.getAction();
        if (action instanceof CaptchaAware && action instanceof ConfluenceActionSupport && ContainerManager.isContainerSetup()) {
            String captchaResponse;
            String captchaId;
            ConfluenceActionSupport confluenceAction = (ConfluenceActionSupport)action;
            CaptchaManager captchaManager = (CaptchaManager)ContainerManager.getComponent((String)"captchaManager");
            if (captchaManager.isCaptchaEnabled() && !captchaManager.validateCaptcha(captchaId = this.getCaptchaId(), captchaResponse = this.getParameter("captchaResponse"))) {
                confluenceAction.addFieldError("captcha", "captcha.response.failed", new String[0]);
                return "input";
            }
        }
        return actionInvocation.invoke();
    }

    private String getCaptchaId() {
        HttpSession session = ServletActionContext.getRequest().getSession(false);
        if (session == null) {
            return null;
        }
        String result = null;
        try {
            result = (String)session.getAttribute("confluence.captchaid");
            session.removeAttribute("confluence.captchaid");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return result;
    }
}

