/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.persistence.dao.hibernate;

import com.atlassian.confluence.security.persistence.dao.hibernate.AliasedKey;
import com.atlassian.confluence.security.trust.KeyStore;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class HibernateKeyStoreDao
extends HibernateDaoSupport
implements KeyStore {
    public PrivateKey getPrivateKey(String alias) {
        return (PrivateKey)this.getKey(alias, "private");
    }

    public PublicKey getPublicKey(String alias) {
        return (PublicKey)this.getKey(alias, "public");
    }

    public KeyPair getKeyPair(String alias) {
        List keys = this.getHibernateTemplate().findByNamedQuery("confluence.ks_getKeysByAlias", new Object[]{alias});
        if (keys.size() < 2) {
            return null;
        }
        if (keys.size() > 2) {
            throw new IncorrectResultSizeDataAccessException(2, keys.size());
        }
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Key javaKey = ((AliasedKey)i.next()).getKey();
            if (javaKey instanceof PublicKey) {
                publicKey = (PublicKey)javaKey;
                continue;
            }
            privateKey = (PrivateKey)javaKey;
        }
        return new KeyPair(publicKey, privateKey);
    }

    private Key getKey(String alias, String keyType) {
        List keys = this.getHibernateTemplate().findByNamedQuery("confluence.ks_getKeyByAliasAndType", new Object[]{alias, keyType});
        AliasedKey aliasedKey = (AliasedKey)DataAccessUtils.singleResult((Collection)keys);
        return aliasedKey.getKey();
    }

    public void storeKeyPair(String alias, KeyPair keyPair) {
        this.storePublicKey(alias, keyPair.getPublic());
        this.storeKey(alias, keyPair.getPrivate());
    }

    private void storeKey(String alias, Key key) {
        AliasedKey aliasedKey = new AliasedKey();
        aliasedKey.setAlias(alias);
        aliasedKey.setKey(key);
        this.getHibernateTemplate().save((Object)aliasedKey);
    }

    public void storePublicKey(String alias, PublicKey publicKey) {
        this.storeKey(alias, publicKey);
    }
}

