/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.trust;

import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.security.persistence.dao.TrustedApplicationDao;
import com.atlassian.confluence.security.trust.AsymmetricKeyFactory;
import com.atlassian.confluence.security.trust.ConfluenceApplication;
import com.atlassian.confluence.security.trust.ConfluenceTrustedApplication;
import com.atlassian.confluence.security.trust.KeyPairInitialiser;
import com.atlassian.confluence.security.trust.KeyStore;
import com.atlassian.confluence.security.trust.TrustedApplicationsManager;
import com.atlassian.confluence.security.trust.TrustedToken;
import com.atlassian.confluence.security.trust.TrustedTokenFactory;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.Collection;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class DefaultTrustedApplicationsManager
implements TrustedApplicationsManager,
KeyPairInitialiser,
TrustedTokenFactory {
    protected final Logger log = Logger.getLogger(this.getClass());
    private AsymmetricKeyFactory asymmetricKeyFactory;
    private ConfluenceSidManager sidManager;
    private KeyStore keyStoreDao;
    private TrustedApplicationDao trustedApplicationDao;

    public void saveTrustedApplication(ConfluenceTrustedApplication trustedApplication) {
        this.trustedApplicationDao.saveHibernateTrustedApplication(trustedApplication);
    }

    public void deleteTrustedApplication(ConfluenceTrustedApplication trustedApplication) {
        this.trustedApplicationDao.deleteHibernateTrustedApplication(trustedApplication);
    }

    public ConfluenceTrustedApplication getTrustedApplicationByAlias(String alias) {
        return this.trustedApplicationDao.findByKeyAlias(alias);
    }

    public TrustedToken getToken() {
        String userName = AuthenticatedUserThreadLocal.getUsername();
        if (userName == null) {
            return null;
        }
        return new EncodedTrustedToken(userName, this.getCurrentApplicationInternal().encode(userName));
    }

    public CurrentApplication getCurrentApplication() {
        ConfluenceApplication app = this.getCurrentApplicationInternal();
        if (app == null) {
            return null;
        }
        return new RestrictedCurrentApplication((CurrentApplication)app);
    }

    public Collection getAllTrustedApplications() {
        return this.trustedApplicationDao.findAll();
    }

    private ConfluenceApplication getCurrentApplicationInternal() {
        String systemAlias = this.getSystemAlias();
        KeyPair keyPair = this.keyStoreDao.getKeyPair(systemAlias);
        if (keyPair == null) {
            return null;
        }
        return new ConfluenceApplication(keyPair, systemAlias);
    }

    private String getSystemAlias() {
        String sid;
        try {
            sid = this.sidManager.getSid();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Unable to retrieve server id", e);
        }
        return DefaultTrustedApplicationsManager.getAliasForSid(sid);
    }

    static String getAliasForSid(String sid) {
        byte[] idHash = ArrayUtils.subarray((byte[])DigestUtils.md5((String)sid), (int)0, (int)3);
        return "confluence:" + new BigInteger(1, idHash).intValue();
    }

    public void initConfluenceKey() throws NoSuchProviderException, NoSuchAlgorithmException {
        CurrentApplication application = this.getCurrentApplication();
        if (application != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Not initialising key pair as one already exists");
            }
            return;
        }
        this.storeCurrentApplication(this.generateNewConfluenceApplication());
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Generated key pair with application id " + this.getCurrentApplication().getID()));
        }
    }

    private ConfluenceApplication generateNewConfluenceApplication() throws NoSuchAlgorithmException, NoSuchProviderException {
        return new ConfluenceApplication(this.asymmetricKeyFactory.getNewKeyPair(), this.getSystemAlias());
    }

    private void storeCurrentApplication(ConfluenceApplication application) {
        if (this.getCurrentApplication() != null) {
            throw new IllegalStateException("Key pair already exists for this instance");
        }
        this.keyStoreDao.storeKeyPair(application.getID(), application.getKeyPair());
    }

    public void setKeyStoreDao(KeyStore keyStoreDao) {
        this.keyStoreDao = keyStoreDao;
    }

    public void setTrustedApplicationDao(TrustedApplicationDao trustedApplicationDao) {
        this.trustedApplicationDao = trustedApplicationDao;
    }

    public void setSidManager(ConfluenceSidManager sidManager) {
        this.sidManager = sidManager;
    }

    public void setAsymmetricKeyFactory(AsymmetricKeyFactory asymmetricKeyFactory) {
        this.asymmetricKeyFactory = asymmetricKeyFactory;
    }

    public ConfluenceTrustedApplication getTrustedApplication(long id) {
        return this.trustedApplicationDao.findById(id);
    }

    public ConfluenceTrustedApplication getTrustedApplicationByName(String applicationName) {
        return this.trustedApplicationDao.findByName(applicationName);
    }

    private static class RestrictedCurrentApplication
    implements CurrentApplication {
        private final String id;
        private final PublicKey publicKey;

        private RestrictedCurrentApplication(CurrentApplication currentApplication) {
            this.id = currentApplication.getID();
            this.publicKey = currentApplication.getPublicKey();
        }

        public EncryptedCertificate encode(String userName) {
            throw new UnsupportedOperationException("Not permitted");
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public String getID() {
            return this.id;
        }
    }

    private static class EncodedTrustedToken
    implements TrustedToken {
        private final String userName;
        private final String encodedKey;
        private final String encodedToken;
        private final String applicationId;

        private EncodedTrustedToken(String userName, EncryptedCertificate certificate) {
            this.userName = userName;
            this.encodedToken = certificate.getCertificate();
            this.applicationId = certificate.getID();
            this.encodedKey = certificate.getSecretKey();
        }

        public String getUserName() {
            return this.userName;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public String getEncodedToken() {
            return this.encodedToken;
        }

        public String getEncodedKey() {
            return this.encodedKey;
        }

        public String toString() {
            return "EncodedTrustedToken: userName: " + this.userName + "; appId: " + this.applicationId;
        }
    }
}

