/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.security.trust.seraph;

import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.UserResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import java.security.Principal;
import org.apache.log4j.Logger;

public class SeraphTrustedApplicationUserResolver
implements UserResolver {
    private UserManager userManager;
    private Logger log = Logger.getLogger(SeraphTrustedApplicationUserResolver.class);

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public Principal resolve(ApplicationCertificate applicationCertificate) {
        try {
            User user = this.userManager.getUser(applicationCertificate.getUserName());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("resolved user [ " + applicationCertificate.getUserName() + " ] to [ " + user + " ]"));
            }
            return user;
        }
        catch (EntityException e) {
            this.log.error((Object)"Error looking up user from application certificate", (Throwable)e);
            return null;
        }
    }
}

