/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Category;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ConfluenceVelocityServlet
extends HttpServlet {
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final Category log = Category.getInstance(ConfluenceVelocityServlet.class);
    private VelocityManager velocityManager = VelocityManager.getInstance();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.velocityManager.init(servletConfig.getServletContext());
        servletConfig.getServletContext().setAttribute("webwork.servlet", (Object)this);
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        return this.velocityManager.createContext(ActionContext.getContext().getValueStack(), request, response);
    }

    protected Template handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Context context) throws Exception {
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        return this.getTemplate(servletPath, this.getEncoding());
    }

    protected String getEncoding() {
        if (!ContainerManager.isContainerSetup()) {
            return "UTF-8";
        }
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        String defaultEncoding = settingsManager.getGlobalSettings().getDefaultEncoding();
        if (TextUtils.stringSet((String)defaultEncoding)) {
            return defaultEncoding;
        }
        return "UTF-8";
    }

    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.velocityManager.getVelocityEngine().getTemplate(name, encoding);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Context context = this.createContext(request, response);
            this.setContentType(request, response);
            Template template = this.handleRequest(request, response, context);
            if (template == null) {
                return;
            }
            this.mergeTemplate(template, context, response);
        }
        catch (Exception e) {
            this.error(request, response, e);
        }
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(DEFAULT_CONTENT_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        PageContext oldPageContext = ServletActionContext.getPageContext();
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        HttpServletRequest request = (HttpServletRequest)context.get("req");
        PageContext pageContext = jspFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
        ActionContext actionContext = ActionContext.getContext();
        actionContext.put((Object)"com.opensymphony.xwork.dispatcher.PageContext", (Object)pageContext);
        JspWriter writer = null;
        try {
            writer = pageContext.getOut();
            template.merge(context, (Writer)writer);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    log.warn((Object)"Problems flushing servlet writer", (Throwable)e);
                }
            }
            jspFactory.releasePageContext(pageContext);
            actionContext.put((Object)"com.opensymphony.xwork.dispatcher.PageContext", (Object)oldPageContext);
        }
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception cause) throws ServletException, IOException {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append("<body bgcolor=\"#ffffff\">");
        html.append("<h2>VelocityServlet : Error processing the template</h2>");
        html.append("<pre>");
        html.append(cause);
        html.append("<br>");
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        html.append(sw.toString());
        html.append("</pre>");
        html.append("</body>");
        html.append("</html>");
        response.getOutputStream().print(html.toString());
    }
}

