/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.FileUtils;
import com.opensymphony.module.sitemesh.util.Container;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CssServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getServletPath();
        if (path.startsWith("/s/")) {
            path = this.stripResourcePrefix(path);
        }
        if (path.startsWith("/styles/")) {
            switch (Container.get()) {
                case 3: {
                    request.getSession().getServletContext().getNamedDispatcher("action").forward((ServletRequest)new OrionSafeHttpServletRequest(request, path), (ServletResponse)response);
                    break;
                }
                default: {
                    request.getSession().getServletContext().getNamedDispatcher("action").forward((ServletRequest)request, (ServletResponse)response);
                    break;
                }
            }
        } else {
            InputStream stylesheet = request.getSession().getServletContext().getResourceAsStream(path);
            if (stylesheet == null) {
                response.sendError(404);
                return;
            }
            try {
                FileUtils.copy((InputStream)stylesheet, (OutputStream)response.getOutputStream());
            }
            finally {
                IOUtils.close(stylesheet);
            }
        }
    }

    private String stripResourcePrefix(String path) {
        Pattern pattern = Pattern.compile("^/s/.*/_(/.*)");
        Matcher match = pattern.matcher(path);
        return match.group(1);
    }

    private static class OrionSafeHttpServletRequest
    implements HttpServletRequest {
        private final HttpServletRequest myRequest;
        private final String path;

        public OrionSafeHttpServletRequest(HttpServletRequest wrappedRequest, String path) {
            this.myRequest = wrappedRequest;
            this.path = path;
        }

        public String getAuthType() {
            return this.myRequest.getAuthType();
        }

        public Cookie[] getCookies() {
            return this.myRequest.getCookies();
        }

        public long getDateHeader(String s) {
            return this.myRequest.getDateHeader(s);
        }

        public String getHeader(String s) {
            return this.myRequest.getHeader(s);
        }

        public Enumeration getHeaders(String s) {
            return this.myRequest.getHeaders(s);
        }

        public Enumeration getHeaderNames() {
            return this.myRequest.getHeaderNames();
        }

        public int getIntHeader(String s) {
            return this.myRequest.getIntHeader(s);
        }

        public String getMethod() {
            return this.myRequest.getMethod();
        }

        public String getPathInfo() {
            return this.myRequest.getPathInfo();
        }

        public String getPathTranslated() {
            return this.myRequest.getPathTranslated();
        }

        public String getContextPath() {
            return this.myRequest.getContextPath();
        }

        public String getQueryString() {
            return this.myRequest.getQueryString();
        }

        public String getRemoteUser() {
            return this.myRequest.getRemoteUser();
        }

        public boolean isUserInRole(String s) {
            return this.myRequest.isUserInRole(s);
        }

        public Principal getUserPrincipal() {
            return this.myRequest.getUserPrincipal();
        }

        public String getRequestedSessionId() {
            return this.myRequest.getRequestedSessionId();
        }

        public String getRequestURI() {
            return this.myRequest.getRequestURI();
        }

        public StringBuffer getRequestURL() {
            return this.myRequest.getRequestURL();
        }

        public String getServletPath() {
            return this.path;
        }

        public HttpSession getSession(boolean b) {
            return this.myRequest.getSession(b);
        }

        public HttpSession getSession() {
            return this.myRequest.getSession();
        }

        public boolean isRequestedSessionIdValid() {
            return this.myRequest.isRequestedSessionIdValid();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.myRequest.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.myRequest.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.myRequest.isRequestedSessionIdFromUrl();
        }

        public Object getAttribute(String s) {
            return this.myRequest.getAttribute(s);
        }

        public Enumeration getAttributeNames() {
            return this.myRequest.getAttributeNames();
        }

        public String getCharacterEncoding() {
            return this.myRequest.getCharacterEncoding();
        }

        public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
            this.myRequest.setCharacterEncoding(s);
        }

        public int getContentLength() {
            return this.myRequest.getContentLength();
        }

        public String getContentType() {
            return this.myRequest.getContentType();
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.myRequest.getInputStream();
        }

        public String getParameter(String s) {
            return this.myRequest.getParameter(s);
        }

        public Enumeration getParameterNames() {
            return this.myRequest.getParameterNames();
        }

        public String[] getParameterValues(String s) {
            return this.myRequest.getParameterValues(s);
        }

        public Map getParameterMap() {
            return this.myRequest.getParameterMap();
        }

        public String getProtocol() {
            return this.myRequest.getProtocol();
        }

        public String getScheme() {
            return this.myRequest.getScheme();
        }

        public String getServerName() {
            return this.myRequest.getServerName();
        }

        public int getServerPort() {
            return this.myRequest.getServerPort();
        }

        public BufferedReader getReader() throws IOException {
            return this.myRequest.getReader();
        }

        public String getRemoteAddr() {
            return this.myRequest.getRemoteAddr();
        }

        public String getRemoteHost() {
            return this.myRequest.getRemoteHost();
        }

        public void setAttribute(String s, Object o) {
            this.myRequest.setAttribute(s, o);
        }

        public void removeAttribute(String s) {
            this.myRequest.removeAttribute(s);
        }

        public Locale getLocale() {
            return this.myRequest.getLocale();
        }

        public Enumeration getLocales() {
            return this.myRequest.getLocales();
        }

        public boolean isSecure() {
            return this.myRequest.isSecure();
        }

        public RequestDispatcher getRequestDispatcher(String s) {
            return this.myRequest.getRequestDispatcher(s);
        }

        public String getRealPath(String s) {
            return this.myRequest.getRealPath(s);
        }
    }
}

