/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.confluence.servlet.ServletManager;
import com.atlassian.confluence.servlet.SpringManagedServlet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Category;

public abstract class DelegatingServletManager
implements ServletManager {
    public static final Category log = Category.getInstance(DelegatingServletManager.class);
    private Map wrappedServlets = new HashMap();

    public void servletDestroyed(SpringManagedServlet springManagedServlet) {
        if (this.getManagedServlet(springManagedServlet) == null) {
            log.warn((Object)("Received a destroy() message for a servlet that hasn't been initialised! " + springManagedServlet.getServletName()));
        } else {
            this.getManagedServlet(springManagedServlet).destroy();
            this.wrappedServlets.remove((Object)springManagedServlet);
        }
    }

    public void service(SpringManagedServlet springManagedServlet, ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Servlet servlet = this.getManagedServlet(springManagedServlet);
        if (servlet == null) {
            throw new ServletException("Request made for servlet that has not yet been initialised");
        }
        servlet.service(request, response);
    }

    public void servletInitialised(SpringManagedServlet springManagedServlet, ServletConfig servletConfig) throws ServletException {
        if (this.getManagedServlet(springManagedServlet) != null) {
            log.warn((Object)("Re-initialising a servlet that we haven't yet had a destroy() message for: " + springManagedServlet.getServletName()));
            this.servletDestroyed(springManagedServlet);
        }
        Servlet wrappedServlet = this.makeNewWrappedServlet();
        wrappedServlet.init(servletConfig);
        this.servletPostInit(wrappedServlet);
        this.wrappedServlets.put(springManagedServlet, wrappedServlet);
    }

    protected abstract Servlet makeNewWrappedServlet();

    protected void servletPostInit(Servlet wrappedServlet) {
    }

    private Servlet getManagedServlet(SpringManagedServlet source) {
        return (Servlet)this.wrappedServlets.get((Object)source);
    }
}

