/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.confluence.links.linktypes.PageCreateLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.servlet.ServletManager;
import com.atlassian.confluence.servlet.SpringManagedServlet;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkRenderer;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.util.UrlUtil;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportWordPageServer
implements ServletManager {
    private WikiStyleRenderer wikiStyleRenderer;
    private BootstrapManager bootstrapManager;
    private SettingsManager settingsManager;
    private PageManager pageManager;
    private PermissionManager permissionManager;

    public void servletDestroyed(SpringManagedServlet springManagedServlet) {
    }

    public void service(SpringManagedServlet springManagedServlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long pageId = Long.parseLong(request.getParameter("pageId"));
        AbstractPage page = this.pageManager.getAbstractPage(pageId);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.EXPORT, page)) {
            try {
                if (request.getRemoteUser() == null) {
                    request.getRequestDispatcher("/notpermitted.action").forward((ServletRequest)request, (ServletResponse)response);
                }
                response.sendError(404);
            }
            catch (ServletException e) {
                throw new RuntimeException("There was a problem serving the attachment:", e);
            }
        } else {
            boolean isMSIE;
            String userAgentHeader = request.getHeader("User-Agent");
            boolean bl = isMSIE = userAgentHeader != null && userAgentHeader.indexOf("MSIE") != -1;
            if (isMSIE) {
                response.addHeader("content-disposition", "attachment;filename=" + GeneralUtil.urlEncode(page.getTitle()) + ".doc");
            } else {
                response.addHeader("content-disposition", "attachment;filename*=" + this.settingsManager.getGlobalSettings().getDefaultEncoding().toLowerCase() + "''" + GeneralUtil.urlEncode(page.getTitle()) + ".doc;");
            }
            response.setHeader("Cache-Control", "max-age=5");
            response.setHeader("Pragma", "");
            response.setDateHeader("Expires", System.currentTimeMillis() + 300L);
            response.setContentType("application/vnd.ms-word;charset=" + this.settingsManager.getGlobalSettings().getDefaultEncoding());
            final PageContext context = page.toPageContext();
            context.setBaseUrl(this.bootstrapManager.getBaseUrl());
            context.setSiteRoot(this.bootstrapManager.getWebAppContextPath());
            context.setOutputType("word");
            context.setLinkRenderer(new LinkRenderer(){

                public String renderLink(Link link, RenderContext renderContext) {
                    StringBuffer buffer = new StringBuffer();
                    if (link instanceof UnresolvedLink || link instanceof UnpermittedLink || link instanceof PageCreateLink) {
                        buffer.append(link.getLinkBody());
                        return buffer.toString();
                    }
                    buffer.append("<a href=\"");
                    if (link.isRelativeUrl()) {
                        buffer.append(context.getBaseUrl());
                    }
                    buffer.append(link.getUrl());
                    buffer.append("\"");
                    if (TextUtils.stringSet((String)link.getTitle())) {
                        buffer.append(" title=\"").append(link.getTitle()).append("\"");
                    }
                    buffer.append(">");
                    buffer.append(UrlUtil.escapeUrlFirstCharacter((String)UrlUtil.escapeSpecialCharacters((String)link.getLinkBody())));
                    buffer.append("</a>");
                    return buffer.toString();
                }
            });
            String renderedPageContent = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, page.getContent());
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("bootstrapManager", this.bootstrapManager);
            paramMap.put("page", page);
            paramMap.put("renderedPageContent", renderedPageContent);
            String renderedTemplate = VelocityUtils.getRenderedTemplate("/pages/exportword.vm", paramMap);
            response.getWriter().print(renderedTemplate);
        }
    }

    public void servletInitialised(SpringManagedServlet springManagedServlet, ServletConfig servletConfig) throws ServletException {
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

