/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.confluence.servlet.download.AttachmentDownload;
import com.atlassian.confluence.servlet.download.ExportDownload;
import com.atlassian.confluence.servlet.download.ResourceDownload;
import com.atlassian.confluence.servlet.download.ThumbnailDownload;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.servlet.BaseFileServerServlet;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.servlet.PluginResourceDownload;
import com.atlassian.renderer.util.FileTypeUtil;
import com.atlassian.spring.container.ContainerManager;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class FileServerServlet
extends BaseFileServerServlet {
    public static final String ATTACHMENTS_URL_PREFIX = "attachments";
    public static final String RESOURCE_URL_PREFIX = "resources";
    public static final String USER_RESOURCE_URL_PREFIX = "userresources";
    public static final String THUMBNAILS_URL_PREFIX = "thumbnails";

    public void init(ServletConfig servletConfig) throws ServletException {
        this.addDownloadStrategy(AttachmentDownload.class);
        this.addDownloadStrategy(ThumbnailDownload.class);
        this.addDownloadStrategy(ExportDownload.class);
        this.addDownloadStrategy(ResourceDownload.class);
        super.init(servletConfig);
    }

    public String getDecodedPathInfo(HttpServletRequest httpServletRequest) {
        return GeneralUtil.urlDecode(httpServletRequest.getPathInfo());
    }

    public DownloadStrategy instantiateDownloadStrategy(Class downloadStrategyClass) {
        if (!ContainerManager.isContainerSetup() && downloadStrategyClass.equals(PluginResourceDownload.class)) {
            return BootstrapUtils.getSimplePluginResourceDownload();
        }
        return (DownloadStrategy)ContainerManager.getInstance().getContainerContext().createComponent(downloadStrategyClass);
    }

    protected String urlDecode(String url) {
        return GeneralUtil.urlDecode(url);
    }

    protected String getContentType(String location) {
        return FileTypeUtil.getContentType((String)location);
    }
}

