/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.spring.container.ContainerManager;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ImageCaptchaServlet
extends HttpServlet {
    private CaptchaManager captchaManager;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        byte[] captchaChallengeAsJpeg = null;
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        try {
            String captchaId = this.getCaptchaManager().generateCaptchaId();
            HttpSession session = httpServletRequest.getSession(true);
            session.setAttribute("confluence.captchaid", (Object)captchaId);
            ImageCaptchaService imageCaptchaService = this.getCaptchaManager().getImageCaptchaService();
            if (imageCaptchaService == null) {
                throw new RuntimeException("There was a problem creating the CAPTCHA service. This probably indicates a problem with Java's image subsystem. You may need to configure your application server to supply the system property java.awt.headless=true.");
            }
            BufferedImage challenge = imageCaptchaService.getImageChallengeForID(captchaId, httpServletRequest.getLocale());
            JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)jpegOutputStream);
            jpegEncoder.encode(challenge);
        }
        catch (IllegalArgumentException e) {
            httpServletResponse.sendError(404);
            return;
        }
        catch (CaptchaServiceException e) {
            httpServletResponse.sendError(500);
            return;
        }
        captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
        responseOutputStream.write(captchaChallengeAsJpeg);
        responseOutputStream.flush();
        responseOutputStream.close();
    }

    public CaptchaManager getCaptchaManager() {
        if (this.captchaManager == null) {
            this.captchaManager = (CaptchaManager)ContainerManager.getComponent((String)"captchaManager");
        }
        return this.captchaManager;
    }
}

