/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.download;

import com.atlassian.confluence.event.events.content.attachment.AttachmentViewEvent;
import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.servlet.FileServerServlet;
import com.atlassian.confluence.servlet.download.AttachmentUrlParser;
import com.atlassian.confluence.servlet.download.ServeAfterTransactionDownload;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.plugin.util.LastModifiedHandler;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AttachmentDownload
extends ServeAfterTransactionDownload {
    protected DownloadResourceManager downloadResourceManager;
    protected AttachmentUrlParser attachmentUrlParser;
    protected EventManager eventManager;

    public boolean matches(String urlPath) {
        return urlPath.indexOf(FileServerServlet.SERVLET_PATH + "/" + this.getUrlPrefix()) != -1;
    }

    public void setDownloadResourceManager(DownloadResourceManager downloadResourceManager) {
        this.downloadResourceManager = downloadResourceManager;
    }

    public void setAttachmentUrlParser(AttachmentUrlParser attachmentUrlParser) {
        this.attachmentUrlParser = attachmentUrlParser;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public InputStream getStreamForDownload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        DownloadResourceReader resourceReader;
        String decodedPath = GeneralUtil.urlDecode(httpServletRequest.getRequestURI());
        try {
            resourceReader = this.downloadResourceManager.getResourceReader(httpServletRequest.getRemoteUser(), decodedPath, httpServletRequest.getParameterMap());
        }
        catch (UnauthorizedDownloadResourceException e) {
            try {
                if (httpServletRequest.getRemoteUser() == null) {
                    httpServletRequest.getRequestDispatcher("/notpermitted.action").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                } else {
                    httpServletResponse.sendError(404);
                }
            }
            catch (ServletException se) {
                throw new RuntimeException("There was a problem serving the attachment:", se);
            }
            return null;
        }
        catch (DownloadResourceNotFoundException e) {
            httpServletResponse.sendError(404);
            return null;
        }
        if (LastModifiedHandler.checkRequest((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Date)resourceReader.getLastModificationDate())) {
            return null;
        }
        InputStream is = resourceReader.getStreamForReading();
        if (is == null) {
            httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/attachmentnotfound.action?pageId=" + Long.toString(this.attachmentUrlParser.getEntityId(decodedPath, this.getUrlPrefix())));
            return null;
        }
        this.setHeadersForAttachment(resourceReader.getName(), resourceReader.getContentLength(), resourceReader.getContentType(), httpServletRequest, httpServletResponse);
        Attachment attachment = this.attachmentUrlParser.getAttachment(decodedPath, this.getUrlPrefix(), httpServletRequest.getParameterMap());
        this.eventManager.publishEvent((Event)new AttachmentViewEvent(this, attachment));
        return is;
    }

    protected String getUrlPrefix() {
        return "attachments";
    }

    protected void setHeadersForAttachment(String name, long contentLength, String contentType, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.isHtml(name, contentType)) {
            httpServletResponse.setContentType("application/x-download");
        } else {
            httpServletResponse.setContentType(contentType);
        }
        httpServletResponse.setHeader("Content-Length", Long.toString(contentLength));
        this.setFileNameHeader(httpServletResponse, name, httpServletRequest.getHeader("User-Agent"));
    }

    protected void setFileNameHeader(HttpServletResponse httpServletResponse, String downloadFileName, String userAgent) {
        if (userAgent != null && userAgent.indexOf("MSIE") >= 0 && userAgent.indexOf("Opera") == -1) {
            String encodedFileName = GeneralUtil.urlEncode(downloadFileName);
            if (encodedFileName.indexOf(43) != -1) {
                encodedFileName = encodedFileName.replaceAll("\\+", "%20");
            }
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"" + encodedFileName + "\"");
            return;
        }
        if (!GeneralUtil.isAllAscii(downloadFileName)) {
            return;
        }
        httpServletResponse.setHeader("Content-Disposition", "inline; filename=\"" + downloadFileName + "\"");
    }

    private boolean isHtml(String name, String contentType) {
        boolean isHtmlFileExtension = TextUtils.stringSet((String)name) && (name.endsWith("htm") || name.endsWith("html"));
        boolean isHtmlContentType = "text/html".equals(contentType);
        return isHtmlFileExtension || isHtmlContentType;
    }
}

