/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.download;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceNotFoundException;
import com.atlassian.confluence.importexport.resource.DownloadResourceReader;
import com.atlassian.confluence.importexport.resource.UnauthorizedDownloadResourceException;
import com.atlassian.confluence.security.DownloadGateKeeper;
import com.atlassian.confluence.servlet.download.ServeAfterTransactionDownload;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExportDownload
extends ServeAfterTransactionDownload {
    private static final Logger log = Logger.getLogger(ExportDownload.class);
    private static final String CONTENTTYPE_PARAM_NAME = "contentType";
    private DownloadResourceManager downloadResourceManager;

    public boolean matches(String urlPath) {
        return urlPath.startsWith(ExportDownload.getExportRoot().toLowerCase());
    }

    protected InputStream getStreamForDownload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        DownloadResourceReader resourceReader;
        try {
            resourceReader = this.downloadResourceManager.getResourceReader(httpServletRequest.getRemoteUser(), GeneralUtil.urlDecode(httpServletRequest.getRequestURI()), httpServletRequest.getParameterMap());
        }
        catch (UnauthorizedDownloadResourceException e) {
            log.error((Object)e);
            httpServletResponse.sendError(403);
            return null;
        }
        catch (DownloadResourceNotFoundException e) {
            log.error((Object)e);
            httpServletResponse.sendError(404);
            return null;
        }
        String contentType = httpServletRequest.getParameter(CONTENTTYPE_PARAM_NAME);
        if (contentType == null) {
            contentType = "application/x-download";
        }
        httpServletResponse.setContentType(contentType);
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + resourceReader.getName());
        httpServletResponse.setHeader("Content-Length", Long.toString(resourceReader.getContentLength()));
        return resourceReader.getStreamForReading();
    }

    public void setDownloadResourceManager(DownloadResourceManager downloadResourceManager) {
        this.downloadResourceManager = downloadResourceManager;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix, GeneralUtil.getConfluenceTempDirectory());
        DownloadGateKeeper gateKeeper = (DownloadGateKeeper)ContainerManager.getInstance().getContainerContext().getComponent((Object)"gateKeeper");
        String path = ExportDownload.getExportRoot().toLowerCase() + "/" + file.getName();
        if (AuthenticatedUserThreadLocal.getUser() != null) {
            gateKeeper.addKey(path, AuthenticatedUserThreadLocal.getUser());
        } else {
            gateKeeper.allowAnonymousAccess(path);
        }
        return file;
    }

    public static String getUrl(File file, String contentType) {
        return ExportDownload.getExportRoot().toLowerCase() + "/" + file.getName() + "?" + CONTENTTYPE_PARAM_NAME + "=" + contentType + "&delete=true";
    }

    public static String getExportRoot() {
        int homeDirIndex;
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        String exportDir = bootstrapManager.getFilePathProperty("webwork.multipart.saveDir");
        if (bootstrapManager.getConfluenceHome() != null && (homeDirIndex = exportDir.indexOf(bootstrapManager.getConfluenceHome())) != -1) {
            exportDir = exportDir.substring(homeDirIndex + bootstrapManager.getConfluenceHome().length() + 1);
        }
        return bootstrapManager.getWebAppContextPath() + "/download/" + exportDir;
    }
}

