/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.download;

import com.atlassian.confluence.servlet.FileServerServlet;
import com.atlassian.confluence.servlet.download.ServeAfterTransactionDownload;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.DefaultResourceManager;
import com.atlassian.confluence.util.Resource;
import com.atlassian.plugin.util.LastModifiedHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceDownload
extends ServeAfterTransactionDownload {
    private DefaultResourceManager defaultResourceManager;
    private SpaceManager spaceManager;

    public boolean matches(String urlPath) {
        return urlPath.indexOf(FileServerServlet.SERVLET_PATH + "/" + "userresources" + "/") != -1;
    }

    protected InputStream getStreamForDownload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Space space;
        String spaceKey = this.findResourceSpaceKey(httpServletRequest);
        String key = this.findResourceKey(httpServletRequest);
        Resource userResource = this.defaultResourceManager.getResource(key, space = this.spaceManager.getSpace(spaceKey));
        if (userResource == null) {
            return null;
        }
        File requestedResource = this.defaultResourceManager.getResourceFile(userResource.getRelativePathToFile(), space);
        if (LastModifiedHandler.checkRequest((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Date)new Date(requestedResource.lastModified()))) {
            return null;
        }
        httpServletResponse.setHeader("Content-Length", Long.toString(requestedResource.length()));
        if (userResource.getContentTypePrefix() != null) {
            int startIdx = userResource.getRelativePathToFile().lastIndexOf(".");
            String ext = userResource.getRelativePathToFile().substring(startIdx + 1);
            httpServletResponse.setContentType(userResource.getContentTypePrefix() + "/" + ext);
        }
        return new FileInputStream(requestedResource);
    }

    private String findResourceKey(HttpServletRequest req) {
        String requestString = req.getRequestURL().toString().toLowerCase();
        int startIdx = requestString.lastIndexOf("/");
        String key = requestString.substring(startIdx + 1, requestString.length());
        return key;
    }

    private String findResourceSpaceKey(HttpServletRequest req) {
        String requestString = req.getRequestURL().toString().toLowerCase();
        int startIdx = requestString.lastIndexOf("download/userresources/");
        String spaceAndResourcekey = requestString.substring(startIdx += "download/userresources/".length(), requestString.length());
        int endIdx = spaceAndResourcekey.indexOf("/");
        if (endIdx == -1) {
            return null;
        }
        String spaceKey = spaceAndResourcekey.substring(0, endIdx);
        return spaceKey;
    }

    public DefaultResourceManager getResourceManager() {
        return this.defaultResourceManager;
    }

    public void setResourceManager(DefaultResourceManager defaultResourceManager) {
        this.defaultResourceManager = defaultResourceManager;
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

