/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.simpledisplay;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;

public class UserPathConverter
implements PathConverter {
    private static final String DISPLAY_USER_PATH = "/users/viewuserprofile.action?username=${username}";
    private SpaceManager spaceManager;
    private UserAccessor userAccessor;
    private PermissionManager permissionManager;

    public boolean handles(String simplePath) {
        return simplePath.startsWith("~") && simplePath.indexOf("/") == -1;
    }

    public ConvertedPath getPath(String simplePath) {
        String userName = simplePath.substring(1);
        User user = this.userAccessor.getUser(userName);
        if (user != null) {
            Space personalSpace = this.spaceManager.getPersonalSpace(user);
            User currentUser = AuthenticatedUserThreadLocal.getUser();
            if (personalSpace != null && this.permissionManager.hasPermission(currentUser, Permission.VIEW, personalSpace)) {
                ConvertedPath convertedPath = new ConvertedPath("/spaces/viewspace.action?key=${key}");
                convertedPath.addParameter("key", "~" + userName);
                return convertedPath;
            }
        }
        ConvertedPath convertedPath = new ConvertedPath(DISPLAY_USER_PATH);
        convertedPath.addParameter("username", userName);
        return convertedPath;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

