/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.bootstrap.BootstrappedContextLoaderListener;
import com.atlassian.plugin.PluginManager;
import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ConfluenceBootstrappedContextLoaderListener
implements ServletContextListener {
    private final ServletContextListener bootstrapContextListener = new BootstrappedContextLoaderListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ConfluenceBootstrapClassLoader bcl = new ConfluenceBootstrapClassLoader(loader);
        Thread.currentThread().setContextClassLoader(bcl);
        try {
            this.bootstrapContextListener.contextInitialized(event);
            if (ContainerManager.isContainerSetup()) {
                PluginManager pluginManager = (PluginManager)ContainerManager.getComponent((String)"pluginManager");
                bcl.setDelegateClassLoader(pluginManager.getClassLoader());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.bootstrapContextListener.contextDestroyed(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfluenceBootstrapClassLoader
    extends ClassLoader {
        private ClassLoader delegate;

        public ConfluenceBootstrapClassLoader(ClassLoader delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate classloader cannot be null");
            }
            this.delegate = delegate;
        }

        void setDelegateClassLoader(ClassLoader delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate classloader cannot be null");
            }
            this.delegate = delegate;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.delegate.loadClass(name);
        }

        @Override
        public URL getResource(String name) {
            return this.delegate.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.delegate.getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.delegate.getResourceAsStream(name);
        }

        @Override
        public void setDefaultAssertionStatus(boolean enabled) {
            this.delegate.setDefaultAssertionStatus(enabled);
        }

        @Override
        public void setPackageAssertionStatus(String packageName, boolean enabled) {
            this.delegate.setPackageAssertionStatus(packageName, enabled);
        }

        @Override
        public void setClassAssertionStatus(String className, boolean enabled) {
            this.delegate.setClassAssertionStatus(className, enabled);
        }

        @Override
        public void clearAssertionStatus() {
            this.delegate.clearAssertionStatus();
        }
    }
}

