/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.core.filters.AbstractEncodingFilter;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfluenceEncodingFilter
extends AbstractEncodingFilter {
    protected String getEncoding() {
        String defaultEncoding = "";
        if (BootstrapUtils.getBootstrapManager().isSetupComplete()) {
            SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
            defaultEncoding = settingsManager.getGlobalSettings().getDefaultEncoding();
        }
        if (TextUtils.stringSet((String)defaultEncoding)) {
            return defaultEncoding;
        }
        return "UTF-8";
    }

    protected String getContentType() {
        return "text/html; charset=" + this.getEncoding();
    }

    protected boolean isNonCachableUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        return uri == null || uri.indexOf(".vm") > 0 || uri.indexOf(".action") > 0 && uri.indexOf("/styles/main-action.action") < 0 || uri.indexOf("/display/") != -1;
    }

    protected void setNonCachingHeaders(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-Control", "no-cache, must-revalidate");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
    }
}

