/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import bucket.core.persistence.hibernate.schema.SchemaHelper;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.config.db.HibernateConfigurator;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.event.events.admin.ConfluenceReadyEvent;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.core.db.JDBCUtils;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;
import org.apache.log4j.Category;

public class DefaultHibernateConfigurator
implements HibernateConfigurator {
    private static Category log = Category.getInstance(DefaultHibernateConfigurator.class);

    public synchronized void configureDatabase(DatabaseDetails dbDetails, boolean embedded) throws ConfigurationException {
        if (embedded) {
            String database_name = ((BootstrapManager)BootstrapUtils.getBootstrapManager()).getConfluenceHome() + "/database/confluencedb";
            dbDetails.setDatabaseUrl("jdbc:hsqldb:" + database_name);
        }
        Properties properties = new Properties();
        properties.setProperty("hibernate.connection.driver_class", dbDetails.getDriverClassName());
        properties.setProperty("hibernate.connection.url", dbDetails.getDatabaseUrl());
        properties.setProperty("hibernate.connection.username", dbDetails.getUserName());
        properties.setProperty("hibernate.connection.password", dbDetails.getPassword());
        properties.setProperty("hibernate.dialect", dbDetails.getDialect());
        properties.setProperty("hibernate.c3p0.max_size", "" + dbDetails.getPoolSize());
        properties.setProperty("hibernate.c3p0.min_size", "0");
        properties.setProperty("hibernate.c3p0.timeout", "30");
        properties.setProperty("hibernate.c3p0.max_statements", "0");
        properties.setProperty("hibernate.c3p0.acquire_increment", "1");
        properties.setProperty("hibernate.c3p0.idle_test_period", "100");
        if (dbDetails.getExtraHibernateProperties() != null) {
            Properties extraHibernateConnectionSettings = dbDetails.getExtraHibernateProperties();
            Enumeration<Object> enu = extraHibernateConnectionSettings.keys();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                properties.setProperty(key, extraHibernateConnectionSettings.getProperty(key));
            }
        }
        this.refreshSpringContextAndCreateDatabase(properties);
    }

    public synchronized void configureDatasource(String datasourceName, String dialect) throws ConfigurationException {
        Properties properties = new Properties();
        properties.setProperty("hibernate.connection.datasource", datasourceName);
        properties.setProperty("hibernate.dialect", dialect);
        this.refreshSpringContextAndCreateDatabase(properties);
    }

    public void unconfigureDatabase() {
        Properties properties = BootstrapUtils.getBootstrapManager().getHibernateProperties();
        Iterator<Object> ot = properties.keySet().iterator();
        while (ot.hasNext()) {
            BootstrapUtils.getBootstrapManager().removeProperty((String)ot.next());
        }
        try {
            BootstrapUtils.getBootstrapManager().save();
        }
        catch (ConfigurationException e) {
            log.error((Object)("Unable to unconfigure failed database config: " + e.getMessage()), (Throwable)e);
        }
    }

    public void refreshSpringContextAndCreateDatabase(Properties properties) throws ConfigurationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring database with properties: " + properties));
        }
        for (String string : properties.keySet()) {
            BootstrapUtils.getBootstrapManager().setProperty(string, (Object)properties.getProperty(string));
        }
        BootstrapUtils.getBootstrapManager().save();
        ContainerContext ctx = ContainerManager.getInstance().getContainerContext();
        ctx.refresh();
        SchemaHelper schemaHelper = (SchemaHelper)ctx.getComponent((Object)"schemaHelper");
        try {
            DefaultHibernateConfigurator.createConfluenceSchema(schemaHelper.getConfiguration());
        }
        catch (MappingException e) {
            log.error((Object)"Error creating Confluence schema.", (Throwable)e);
        }
        BootstrapUtils.getBootstrapManager().setProperty("hibernate.setup", (Object)"true");
        EventManager eventManager = (EventManager)ctx.getComponent((Object)"eventManager");
        eventManager.publishEvent((Event)new ConfluenceReadyEvent(this));
    }

    public static void createConfluenceSchema(Configuration hibernateConfig) {
        try {
            SchemaExport schemaExport = new SchemaExport(hibernateConfig);
            schemaExport.drop(log.isDebugEnabled(), true);
            schemaExport.create(log.isDebugEnabled(), true);
            DefaultHibernateConfigurator.createAdditionalDatabaseIndexes(hibernateConfig);
        }
        catch (MappingException e) {
            log.error((Object)"Error while creating database schema", (Throwable)e);
        }
        catch (HibernateException e) {
            log.error((Object)"Error while creating database schema", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAdditionalDatabaseIndexes(Configuration hibernateConfig) {
        ArrayList<String> createIndexSql = new ArrayList<String>();
        createIndexSql.add("create index c_contenttype_idx on CONTENT (CONTENTTYPE)");
        createIndexSql.add("create index ospe_entityid_idx on OS_PROPERTYENTRY (entity_id)");
        createIndexSql.add("create index c_pageid_idx on CONTENT (PAGEID)");
        Connection conn = null;
        Statement s = null;
        try {
            conn = ConnectionProviderFactory.newConnectionProvider((Properties)hibernateConfig.getProperties()).getConnection();
            s = conn.createStatement();
            for (String sql : createIndexSql) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sql);
                }
                s.execute(sql);
            }
        }
        catch (Exception e) {
            try {
                log.error((Object)"Error creating additional indexes.", (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(s);
                JDBCUtils.close((Connection)conn);
                throw throwable;
            }
            JDBCUtils.close((Statement)s);
            JDBCUtils.close((Connection)conn);
        }
        JDBCUtils.close((Statement)s);
        JDBCUtils.close((Connection)conn);
    }
}

