/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.opensymphony.util.TextUtils;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Category;

public class Resin3ContextListener
implements ServletContextListener {
    public static final Category log = Category.getInstance(Resin3ContextListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        if (Resin3ContextListener.isPatchRequiredAndMissing(servletContext)) {
            JohnsonEventContainer agentJohnson = JohnsonEventContainer.get((ServletContext)servletContext);
            agentJohnson.addEvent(new Event(JohnsonConfig.getInstance().getEventType("bootstrap"), "Confluence has detected that you using Resin 3, but with the wrong web.xml file. To fix this, remove the confluence/WEB-INF/web.xml file and rename confluence/WEB-INF/web.resin3.xml to web.xml. Now restart Confluence. These instructions can also be found <a href='http://confluence.atlassian.com/x/E9EC'>here</a>.", JohnsonConfig.getInstance().getEventLevel("fatal")));
            log.error((Object)"Confluence has detected that you using Resin 3, but with the wrong web.xml file. To fix this, remove the confluence/WEB-INF/web.xml file and rename the confluence/WEB-INF/web.resin3.xml to web.xml. Now restart Confluence.");
        }
    }

    public static boolean isPatchRequiredAndMissing(ServletContext servletContext) {
        return Resin3ContextListener.isAppserverResin3(servletContext) && !Resin3ContextListener.isResin3PatchApplied(servletContext);
    }

    private static boolean isAppserverResin3(ServletContext servletContext) {
        return TextUtils.stringSet((String)servletContext.getServerInfo()) && servletContext.getServerInfo().indexOf("Resin/3") != -1;
    }

    private static boolean isResin3PatchApplied(ServletContext servletContext) {
        String appserverName = servletContext.getInitParameter("atlassian.confluence.appServer");
        return TextUtils.stringSet((String)appserverName) && appserverName.equalsIgnoreCase("resin3");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

