/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceException;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractSetupEmailAction
extends ConfluenceActionSupport
implements Administrative {
    private static final Logger log = Logger.getLogger(AbstractSetupEmailAction.class);
    private String name;
    private String from;
    private String prefix = "[confluence]";
    private String userName;
    private String password;
    private String hostname;
    private String jndiName;
    private Long id;
    private MailServerManager mailServerManager;

    public void validate() {
        String[] hostnameAndPort;
        boolean hostNameIsBlank = StringUtils.isBlank((String)this.getHostname());
        boolean jndiNameIsBlank = StringUtils.isBlank((String)this.getJndiName());
        if (hostNameIsBlank && jndiNameIsBlank) {
            this.addActionError("setup.smtp.mail.server.not.specified");
        } else if (!hostNameIsBlank && !jndiNameIsBlank) {
            this.addActionError("setup.smtp.mail.servers.both.specified");
        } else if (!hostNameIsBlank && (hostnameAndPort = this.getHostnameAndPort()).length > 1) {
            try {
                Integer.parseInt(hostnameAndPort[1]);
            }
            catch (NumberFormatException e) {
                this.addFieldError("hostname", "smtp.mail.port.is.not.a.number");
            }
        }
    }

    public String getName() {
        return StringUtils.isNotBlank((String)this.name) ? this.name : this.getText("default.smtp.server.name");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String doDefault() throws Exception {
        SMTPMailServer server = this.getSmtpMailServer();
        if (server != null) {
            this.name = server.getName();
            this.from = server.getDefaultFrom();
            this.prefix = server.getPrefix();
            this.userName = server.getUsername();
            this.password = server.getPassword();
        }
        return super.doDefault();
    }

    protected SMTPMailServer getSmtpMailServer() throws ConfluenceException {
        try {
            return MailFactory.getServerManager().getDefaultSMTPMailServer();
        }
        catch (MailException e) {
            log.error((Object)"Error retrieving smtp server.", (Throwable)e);
            return null;
        }
    }

    protected String[] getHostnameAndPort() {
        return this.getHostname().split(":");
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMailServerManager(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    protected MailServerManager getMailServerManager() {
        return this.mailServerManager;
    }
}

