/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.lifecycle.LifecycleManager;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.trust.KeyPairInitialiser;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.confluence.setup.settings.GlobalDescription;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FinishSetupAction
extends AbstractSetupAction {
    private String installationMethod;
    boolean demonstrationContentInstalled;
    private LifecycleManager lifecycleManager;
    private ConfluenceSidManager sidManager;
    private KeyPairInitialiser keyPairInitialiser;

    public String execute() throws Exception {
        this.getSetupPersister().progessSetupStep();
        this.performFinalInitialisation();
        if (this.getSetupPersister().isDemonstrationContentInstalled()) {
            this.demonstrationContentInstalled = true;
            this.fixOwnershipAndPermissionsOfDemoSpace();
        }
        this.getSetupPersister().finishSetup();
        this.spacePermissionManager.flushCaches();
        this.installationMethod = this.getSetupPersister().getSetupType();
        Settings globalSettings = this.settingsManager.getGlobalSettings();
        globalSettings.setGlobalDefaultLocale(this.getLocale().toString());
        this.settingsManager.updateGlobalSettings(globalSettings);
        if (this.settingsManager.getGlobalDescription() == null) {
            this.settingsManager.updateGlobalDescription(new GlobalDescription());
        }
        this.getBootstrapManager().publishConfiguration();
        this.lifecycleManager.startUp(ServletActionContext.getServletContext());
        return "success";
    }

    private void performFinalInitialisation() throws ConfigurationException, NoSuchProviderException, NoSuchAlgorithmException {
        if (!this.sidManager.isSidSet()) {
            this.sidManager.initSid();
        }
        this.keyPairInitialiser.initConfluenceKey();
    }

    private void fixOwnershipAndPermissionsOfDemoSpace() {
        SpaceManager spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
        SpacePermissionManager spacePermissionManager = (SpacePermissionManager)ContainerManager.getComponent((String)"spacePermissionManager");
        User user = this.getRemoteUser();
        List spaces = spaceManager.getSpacesByType(SpaceType.GLOBAL);
        if (spaces.size() == 1) {
            Space space = (Space)spaces.get(0);
            if (user != null) {
                space.setCreatorName(user.getName());
            }
            ArrayList oldSpacePermissions = new ArrayList(space.getPermissions());
            Iterator it = oldSpacePermissions.iterator();
            while (it.hasNext()) {
                spacePermissionManager.removePermission((SpacePermission)it.next());
            }
            for (String permissionStr : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
                spacePermissionManager.savePermission(new SpacePermission(permissionStr, space, "confluence-administrators"));
                if (user != null) {
                    spacePermissionManager.savePermission(new SpacePermission(permissionStr, space, null, user.getName()));
                }
                if ("SETSPACEPERMISSIONS".equals(permissionStr)) continue;
                spacePermissionManager.savePermission(new SpacePermission(permissionStr, space, "confluence-users"));
                if (SpacePermission.INVALID_ANONYMOUS_PERMISSIONS.contains(permissionStr)) continue;
                spacePermissionManager.savePermission(new SpacePermission(permissionStr, space));
            }
        }
    }

    public String getInstallationMethod() {
        return this.installationMethod;
    }

    public void setInstallationMethod(String installationMethod) {
        this.installationMethod = installationMethod;
    }

    public boolean isDemonstrationContentInstalled() {
        return this.demonstrationContentInstalled;
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public void setSidManager(ConfluenceSidManager sidManager) {
        this.sidManager = sidManager;
    }

    public void setKeyPairInitialiser(KeyPairInitialiser keyPairInitialiser) {
        this.keyPairInitialiser = keyPairInitialiser;
    }
}

