/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.confluence.setup.Resin3ContextListener;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.opensymphony.webwork.ServletActionContext;
import org.apache.log4j.Category;

public class SelectSetupStepAction
extends AbstractSetupAction {
    public static final Category log = Category.getInstance(SelectSetupStepAction.class);
    private boolean jdk14;
    private boolean servlet23;
    private boolean confluenceHomeOk;
    private boolean resin3Ok;
    public static final String RESULT_PRECONDITIONS_FAILED = "checklist";
    private String currentSetupActionName;

    public String execute() {
        if (this.getBootstrapManager().isSetupComplete()) {
            return "success";
        }
        if (!(this.checkConfluenceHomeOk() & this.checkJdk14() & this.checkServlet23() & this.checkResin3())) {
            return RESULT_PRECONDITIONS_FAILED;
        }
        this.currentSetupActionName = "/setup/" + this.getSetupPersister().getCurrentStep() + ".action";
        log.debug((Object)("current setup step is " + this.currentSetupActionName));
        return "success";
    }

    private boolean checkResin3() {
        this.resin3Ok = !Resin3ContextListener.isPatchRequiredAndMissing(ServletActionContext.getServletContext());
        return this.resin3Ok;
    }

    public String getCurrentStep() {
        return this.currentSetupActionName;
    }

    public boolean isPermitted() {
        return true;
    }

    public boolean isJdk14() {
        return this.jdk14;
    }

    public boolean isServlet23() {
        return this.servlet23;
    }

    public boolean isConfluenceHomeOk() {
        return this.confluenceHomeOk;
    }

    public boolean checkJdk14() {
        this.jdk14 = this.classFound("java.util.LinkedHashSet");
        return this.jdk14;
    }

    public boolean checkServlet23() {
        this.servlet23 = this.classFound("javax.servlet.Filter");
        return this.servlet23;
    }

    public boolean isResin3Ok() {
        return this.resin3Ok;
    }

    public boolean checkConfluenceHomeOk() {
        this.confluenceHomeOk = this.getBootstrapManager().isApplicationHomeValid();
        return this.confluenceHomeOk;
    }

    public String getJdkName() {
        return System.getProperty("java.vendor") + " - " + System.getProperty("java.version");
    }

    public String getServerName() {
        return ServletActionContext.getServletContext().getServerInfo();
    }

    private boolean classFound(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                try {
                    clazz = this.getClass().getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    log.info((Object)("Class not found " + className + ": " + e), (Throwable)e);
                }
            }
        }
        return clazz != null;
    }

    public boolean isEverythingOk() {
        return this.isJdk14() && this.isServlet23() && this.isConfluenceHomeOk() && this.isResin3Ok();
    }
}

