/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Collection;
import org.apache.log4j.Logger;

public class SetupAdministrator
extends AbstractSetupAction {
    private static final Logger log = Logger.getLogger(SetupAdministrator.class);
    private String username = "admin";
    private String password;
    private String confirm;
    private String email;
    private String fullname;
    private boolean test;
    public Group confluenceAdministrators;
    public Group confluenceUsers;

    public void setTest(boolean test) {
        this.test = test;
    }

    public String execute() throws Exception {
        if (this.adminUserExists()) {
            this.addFieldError("username", this.getText("admin.exists"));
            return "input";
        }
        this.createDefaultGroups();
        this.setDefaultPermissions();
        this.createAdmin();
        this.loginAdmin();
        this.getSetupPersister().progessSetupStep();
        if ("install".equals(this.getSetupPersister().getSetupType())) {
            return "quick-setup";
        }
        if ("custom".equals(this.getSetupPersister().getSetupType())) {
            return "custom-setup";
        }
        return super.execute();
    }

    private void createDefaultGroups() {
        try {
            this.confluenceAdministrators = this.userAccessor.getGroupCreateIfNecessary("confluence-administrators");
        }
        catch (Exception e) {
            String msg = "Failed to create default group: confluence-administrators";
            throw new InfrastructureException(msg, (Throwable)e);
        }
        try {
            this.confluenceUsers = this.userAccessor.getGroupCreateIfNecessary("confluence-users");
        }
        catch (Exception e) {
            String msg = "Failed to create default group: confluence-users";
            throw new InfrastructureException(msg, (Throwable)e);
        }
    }

    private void setDefaultPermissions() {
        Collection defaultPerms = SpacePermission.getDefaultGlobalPermissions();
        for (SpacePermission spacePermission : defaultPerms) {
            this.spacePermissionManager.savePermission(spacePermission);
        }
    }

    private void createAdmin() {
        try {
            String[] groups = UserAccessor.DEFAULT_GROUP_NAMES.toArray(new String[0]);
            this.userAccessor.addUser(this.username, this.password, this.email, this.fullname, groups);
        }
        catch (Exception e) {
            throw new InfrastructureException("Failed to create admin user", (Throwable)e);
        }
    }

    private boolean adminUserExists() {
        String repository;
        User user = this.userAccessor.getUser(this.username);
        if (user == null) {
            return false;
        }
        try {
            repository = this.userAccessor.getRepository((Entity)user).getName();
        }
        catch (Exception e) {
            throw new InfrastructureException("Error getting repository of existing admin user:" + this.username, (Throwable)e);
        }
        log.warn((Object)("Found existing user named [" + this.username + "] in repository [" + repository + "]"));
        return true;
    }

    private void loginAdmin() throws AuthenticatorException {
        if (this.test) {
            return;
        }
        SecurityConfigFactory.getInstance().getAuthenticator().login(ServletActionContext.getRequest(), ServletActionContext.getResponse(), this.username, this.password, true);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }
}

