/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.confluence.setup.actions.AbstractSetupDatabaseAction;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Category;

public class SetupDatasourceAction
extends AbstractSetupDatabaseAction {
    private static Category log = Category.getInstance(SetupDatasourceAction.class);
    private String datasourceName = "java:comp/env/jdbc/";
    private String dialect;
    private boolean forceOverwriteExistingData = false;
    private static final String DATA_EXISTS = "data-exists";

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String doDefault() throws Exception {
        this.dbDetails = DatabaseDetails.getDefaults((String)this.getDatabase());
        return "input";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        Connection connection = null;
        try {
            connection = this.getBootstrapManager().getTestDatasourceConnection(this.datasourceName);
            if (!this.forceOverwriteExistingData && this.getBootstrapManager().databaseContainsExistingData(connection)) {
                this.addActionError(this.getText("setup.database.tables.exist"));
                String string = DATA_EXISTS;
                return string;
            }
        }
        catch (Exception e) {
            this.addActionError(this.getText("could.not.lookup.datasource") + ": " + e);
            log.warn((Object)("Unable to look up datasource: " + e.getMessage()), (Throwable)e);
            String string = "error";
            return string;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {}
        }
        try {
            this.dbDetails.setupForDatabase(this.getDatabase());
            this.getBootstrapManager().bootstrapDatasource(this.datasourceName, this.dbDetails.getDialect());
            this.getSetupPersister().progessSetupStep();
        }
        catch (Exception e) {
            this.addActionError(this.getText("configuring.db.failed"));
            this.addActionError(e.getMessage());
            this.registerLoggingErrorEventsWithAction(this.getErrorLevelLogsEvents());
            log.error((Object)("Unable to bootstrap datasource: " + e.getMessage()), (Throwable)e);
            return "error";
        }
        return "success";
    }

    public void setForceOverwriteExistingData(boolean forceOverwriteExistingData) {
        this.forceOverwriteExistingData = forceOverwriteExistingData;
    }
}

