/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.config.setup.SetupPersister;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.ImportedObjectPostProcessor;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.lucene.ConfluenceBatchIndexer;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.spring.container.ContainerManager;
import java.net.URL;
import java.util.Date;
import org.apache.log4j.Logger;

public class SetupDemoContentAction
extends AbstractSetupAction {
    private static final Logger log = Logger.getLogger(SetupDemoContentAction.class);
    private URL demoSiteUrl = null;
    private ImportExportManager importExportManager;
    private ConfluenceBatchIndexer confluenceBatchIndexer;

    public String execute() {
        URL demoSiteZipUrl = this.getDemoSiteUrl();
        if (demoSiteZipUrl == null) {
            log.error((Object)"Could not find demo-site.zip on the classpath.");
            this.addActionError(this.getText("error.could.not.find", new Object[]{"demo-site.zip"}));
            return "error";
        }
        DefaultImportContext ctx = new DefaultImportContext(demoSiteZipUrl, null);
        final Date importStart = new Date();
        ctx.setPostProcessor(new ImportedObjectPostProcessor(){

            public boolean process(Object obj) {
                if (obj instanceof ConfluenceEntityObject) {
                    ConfluenceEntityObject entityObject = (ConfluenceEntityObject)obj;
                    if (entityObject instanceof Page) {
                        entityObject.setLastModificationDate(new Date());
                    } else {
                        entityObject.setLastModificationDate(importStart);
                    }
                    return true;
                }
                return false;
            }
        });
        try {
            if (this.importExportManager == null) {
                this.importExportManager = (ImportExportManager)ContainerManager.getComponent((String)"importExportManager");
            }
            if (this.confluenceBatchIndexer == null) {
                this.confluenceBatchIndexer = (ConfluenceBatchIndexer)ContainerManager.getComponent((String)"confluenceBatchIndexer");
            }
            this.importExportManager.importAs("TYPE_ALL_DATA", ctx);
            this.getSetupPersister().setDemonstrationContentInstalled();
            this.confluenceBatchIndexer.reIndexAll();
        }
        catch (ImportExportException e) {
            log.error((Object)"Could not import demo-site.zip: ", (Throwable)e);
            this.addActionError("Could not import demo-site.zip: " + e);
            return "error";
        }
        catch (NullPointerException e) {
            log.error((Object)"importExportManager was most probably null (check the Spring context): ", (Throwable)e);
            this.addActionError(this.getText("error.failure.loading.demo.content", new Object[]{e}));
            return "error";
        }
        this.getSetupPersister().progessSetupStep();
        if (this.getActionErrors().size() != 0) {
            return "error";
        }
        return "success";
    }

    private URL getDemoSiteUrl() {
        if (this.demoSiteUrl != null) {
            return this.demoSiteUrl;
        }
        return ClassLoaderUtils.getResource((String)"com/atlassian/confluence/setup/demo-site.zip", SetupPersister.class);
    }

    public void setDemoSiteUrl(URL demoSiteUrl) {
        this.demoSiteUrl = demoSiteUrl;
    }

    public ImportExportManager getImportExportManager() {
        return this.importExportManager;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setConfluenceBatchIndexer(ConfluenceBatchIndexer confluenceBatchIndexer) {
        this.confluenceBatchIndexer = confluenceBatchIndexer;
    }
}

