/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.LicenseUtils;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Category;

public class SetupLicenseAction
extends AbstractSetupAction {
    private static final Category log = Category.getInstance(SetupLicenseAction.class);
    private String licenseString;
    private String setupType;
    private final DateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy");
    private final ConfluenceSidManager sidManager = SidManagerFactory.getSidManager();

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public String getServerId() throws ConfigurationException {
        return this.sidManager.getSid();
    }

    private void validateLicense() {
        String errorMsg;
        License newLicense = LicenseManager.getInstance().setLicense(this.licenseString, "CONF");
        if (newLicense == null) {
            log.fatal((Object)"License is not valid");
            this.addFieldError("licenseString", this.getText("error.license.not.valid"));
            return;
        }
        Date supportPeriodEndDate = new Date(LicenseUtils.getSupportPeriodEnd((License)newLicense));
        String supportPeriodEndDateString = this.dateFormatter.format(supportPeriodEndDate);
        Date buildDate = GeneralUtil.getBuildDate();
        if (buildDate != null && buildDate.after(supportPeriodEndDate)) {
            log.fatal((Object)("License too old, buildDate is " + buildDate + " (" + this.dateFormatter.format(buildDate) + " ) +  and support expired at " + supportPeriodEndDate + " (" + supportPeriodEndDateString + " )"));
            this.addFieldError("licenseString", this.getText("error.license.too.old", new String[]{supportPeriodEndDateString}));
        }
        if (TextUtils.stringSet((String)(errorMsg = GeneralUtil.checkPartnerDetails(newLicense, GeneralUtil.getBuildPartner())))) {
            log.fatal((Object)"License does not match partner");
            this.addFieldError("licenseString", errorMsg);
        }
    }

    public void validate() {
        if (TextUtils.stringSet((String)this.licenseString)) {
            this.validateLicense();
        } else {
            this.addFieldError("licenseString", this.getText("error.license.required"));
        }
        if (!TextUtils.stringSet((String)this.getSetupType())) {
            this.addActionError(this.getText("error.no.setup.type"));
        }
    }

    public String doDefault() throws Exception {
        if (!this.sidManager.isSidSet()) {
            this.sidManager.initSid();
        }
        return super.doDefault();
    }

    public String execute() throws Exception {
        BootstrapManager confSetup = this.getBootstrapManager();
        confSetup.setBuildNumber(GeneralUtil.getBuildNumber());
        confSetup.save();
        if (!this.setupConfluenceHome()) {
            return "error";
        }
        String setupType = this.getSetupType();
        if (LicenseManager.getInstance().getLicense("CONF").getPermittedClusteredNodes() > 0) {
            if (setupType.equals("install")) {
                this.addActionError(this.getText("error.no.quick.setup.for.cluster"));
                return "error";
            }
            setupType = "cluster";
        }
        this.getSetupPersister().setSetupType(setupType);
        this.getSetupPersister().progessSetupStep();
        if (setupType.equals("install")) {
            return "quick-setup";
        }
        if (setupType.equals("custom")) {
            return "custom-setup";
        }
        if (setupType.equals("cluster")) {
            return "cluster-setup";
        }
        throw new RuntimeException("unexpected setup type " + setupType);
    }

    public String getSetupType() {
        if (this.setupType == null) {
            if (TextUtils.stringSet((String)ServletActionContext.getRequest().getParameter("setupTypeInstall"))) {
                this.setupType = "install";
            }
            if (TextUtils.stringSet((String)ServletActionContext.getRequest().getParameter("setupTypeCustom"))) {
                this.setupType = "custom";
            }
        }
        return this.setupType;
    }

    private boolean setupConfluenceHome() {
        String confluenceHomeDir = "${confluenceHome}" + System.getProperty("file.separator");
        String confluenceLuceneIndexDir = confluenceHomeDir + "index";
        String confluenceTempDir = confluenceHomeDir + "temp";
        this.setupDirectory(confluenceLuceneIndexDir, "luceneIndexDir", "creating.lucene.index.dir.failed");
        this.setupDirectory(confluenceTempDir, "tempDir", "creating.temp.dir.failed");
        try {
            BootstrapManager bootstrapManager = this.getBootstrapManager();
            bootstrapManager.setProperty("lucene.index.dir", confluenceLuceneIndexDir);
            bootstrapManager.setProperty("webwork.multipart.saveDir", confluenceTempDir);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Unable to setup Confluence home", (Throwable)e);
            this.addActionError(this.getText("error.recording.default.paths.to.system"));
            return false;
        }
    }

    private File setupDirectory(String dirName, String fieldName, String failureMessageKey) {
        File dir;
        if (dirName == null || dirName.trim().equals("")) {
            return null;
        }
        if (dirName.startsWith("${confluenceHome}")) {
            dirName = this.getBootstrapManager().getConfluenceHome() + dirName.substring("${confluenceHome}".length());
        }
        if (!(dir = new File(dirName)).isDirectory() && !dir.mkdirs()) {
            this.addFieldError(fieldName, this.getText(failureMessageKey));
            return null;
        }
        return dir;
    }

    private static final class SidManagerFactory {
        private static ConfluenceSidManager sidManager;

        private SidManagerFactory() {
        }

        public static ConfluenceSidManager getSidManager() {
            if (sidManager == null) {
                sidManager = (ConfluenceSidManager)BootstrapUtils.getBootstrapContext().getBean("setupSidManager");
            }
            return sidManager;
        }
    }
}

