/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.bandana;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaConfigMap;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.xstream.XStreamManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.core.util.FileUtils;
import com.opensymphony.util.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.log4j.Category;

public class ConfluenceBandanaPersister
implements BandanaPersister {
    public static final String CONFIG_DIRECTORY_NAME = "config";
    public static final String GLOBAL_CONFIG_FILE_NAME = "confluence-global.bandana.xml";
    public static final String SPACE_CONFIG_FILE_NAME = "confluence-space.bandana.xml";
    private static final Category log = Category.getInstance(ConfluenceBandanaPersister.class);
    private XStreamManager xStreamManager;
    private BootstrapManager bootstrapManager;

    public Object retrieve(BandanaContext context, String key) {
        ConfluenceBandanaContext cContext = (ConfluenceBandanaContext)context;
        if (this.hasExistingConfigMap(cContext)) {
            return this.loadBandanaMap(cContext).get(key);
        }
        return null;
    }

    public Map retrieve(BandanaContext context) {
        return this.loadBandanaMap((ConfluenceBandanaContext)context).getValues();
    }

    public void store(BandanaContext context, String key, Object configuration) {
        ConfluenceBandanaConfigMap map;
        ConfluenceBandanaContext cContext = (ConfluenceBandanaContext)context;
        if (this.hasExistingConfigMap(cContext)) {
            map = this.loadBandanaMap(cContext);
        } else {
            map = new ConfluenceBandanaConfigMap();
            map.setContext(cContext);
        }
        map.put(key, configuration);
        this.saveBandanaMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfluenceBandanaConfigMap loadBandanaMap(ConfluenceBandanaContext cContext) {
        ConfluenceBandanaConfigMap confluenceBandanaConfigMap;
        FileInputStream fis = null;
        try {
            File configFile = this.getConfigFile(cContext);
            if (!configFile.exists()) {
                throw new IllegalArgumentException("Configuration for context: " + cContext + " does not exist?");
            }
            fis = new FileInputStream(configFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, this.getEncoding()));
            ConfluenceBandanaConfigMap bandanaMap = (ConfluenceBandanaConfigMap)this.xStreamManager.getXstream().fromXML((Reader)reader);
            fis.close();
            confluenceBandanaConfigMap = bandanaMap;
        }
        catch (Throwable e) {
            ConfluenceBandanaConfigMap confluenceBandanaConfigMap2;
            try {
                log.error((Object)("Error loading stream for context : " + cContext), e);
                ConfluenceBandanaConfigMap newMap = new ConfluenceBandanaConfigMap();
                newMap.setContext(cContext);
                confluenceBandanaConfigMap2 = newMap;
            }
            catch (Throwable throwable) {
                IOUtils.close(fis);
                throw throwable;
            }
            IOUtils.close(fis);
            return confluenceBandanaConfigMap2;
        }
        IOUtils.close(fis);
        return confluenceBandanaConfigMap;
    }

    private synchronized void saveBandanaMap(ConfluenceBandanaConfigMap map) {
        try {
            File configFile = this.getConfigFile(map.getContext());
            FileUtils.ensureFileAndPathExist((File)configFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), this.getEncoding());
            this.xStreamManager.getXstream().toXML((Object)map, (Writer)writer);
        }
        catch (IOException e) {
            log.error((Object)("Error writing bandana map for context: " + map.getContext()), (Throwable)e);
        }
    }

    private String getEncoding() {
        return "UTF-8";
    }

    private File getConfigFile(ConfluenceBandanaContext cContext) {
        String path = this.getBasePath();
        if (cContext.getSpaceKey() != null) {
            return new File(new File(this.getBasePath(), cContext.getSpaceKey()), SPACE_CONFIG_FILE_NAME);
        }
        return new File(path, GLOBAL_CONFIG_FILE_NAME);
    }

    protected String getBasePath() {
        return this.bootstrapManager.getConfluenceHome() + File.separator + CONFIG_DIRECTORY_NAME + File.separator;
    }

    private boolean hasExistingConfigMap(ConfluenceBandanaContext cContext) {
        return this.getConfigFile(cContext).exists();
    }

    public void setxStreamManager(XStreamManager xStreamManager) {
        this.xStreamManager = xStreamManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void flushCaches() {
        throw new UnsupportedOperationException();
    }

    public void remove(BandanaContext bandanaContext) {
        ConfluenceBandanaContext confluenceBandanaContext = (ConfluenceBandanaContext)bandanaContext;
        String spaceKey = confluenceBandanaContext.getSpaceKey();
        File configFile = this.getConfigFile(confluenceBandanaContext);
        if (TextUtils.stringSet((String)spaceKey)) {
            FileUtils.deleteDir((File)configFile.getParentFile());
        } else {
            configFile.delete();
        }
    }

    public void remove(BandanaContext context, String key) {
        ConfluenceBandanaConfigMap map = this.loadBandanaMap((ConfluenceBandanaContext)context);
        map.getValues().remove(key);
        this.saveBandanaMap(map);
    }
}

