/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.bandana;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaRecord;
import com.atlassian.confluence.setup.bandana.persistence.dao.ConfluenceBandanaRecordDao;
import com.atlassian.confluence.setup.xstream.XStreamManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;

public class ConfluenceDaoBandanaPersister
implements BandanaPersister {
    private static Category log = Category.getInstance(ConfluenceDaoBandanaPersister.class);
    private ConfluenceBandanaRecordDao dao;
    private XStreamManager xStreamManager;
    public static final String GLOBAL_BANDANA_CONTEXT = "_GLOBAL";

    public Object retrieve(BandanaContext context, String key) {
        ConfluenceBandanaRecord record = this.dao.getRecord(this.toContextKey(context), key);
        return record == null ? null : this.getObjectFromValue(record);
    }

    public Map retrieve(BandanaContext context) {
        Collection c = this.dao.findForContext(this.toContextKey(context));
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (ConfluenceBandanaRecord r : c) {
            Object o = this.getObjectFromValue(r);
            if (o == null) continue;
            m.put(r.getKey(), o);
        }
        return m;
    }

    private String toContextKey(BandanaContext context) {
        if (!(context instanceof ConfluenceBandanaContext)) {
            throw new ClassCastException("expected ConfluenceBandanaContext but got " + context.getClass());
        }
        return ((ConfluenceBandanaContext)context).getContextKey();
    }

    public void store(BandanaContext context, String key, Object value) {
        this.dao.saveOrUpdate(new ConfluenceBandanaRecord(this.toContextKey(context), key, this.xStreamManager.getXstream().toXML(value)));
    }

    public void flushCaches() {
    }

    public void remove(BandanaContext context) {
        this.dao.removeAllInContext(this.toContextKey(context));
    }

    public void remove(BandanaContext context, String key) {
        this.dao.remove(new ConfluenceBandanaRecord(this.toContextKey(context), key, null));
    }

    private Object getObjectFromValue(ConfluenceBandanaRecord record) {
        try {
            return this.xStreamManager.getXstream().fromXML(record.getValue());
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Configuration could not be loaded because class could not be found (context: " + record.getContext() + ", key: " + record.getKey() + ").\n" + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public void setConfluenceBandanaRecordDao(ConfluenceBandanaRecordDao dao) {
        this.dao = dao;
    }

    public void setxStreamManager(XStreamManager xStreamManager) {
        this.xStreamManager = xStreamManager;
    }
}

